/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionConfigImpl;
import org.apache.geode.internal.admin.SSLConfig;
import org.apache.geode.internal.security.SecurableCommunicationChannel;

public class SSLConfigurationFactory {
    public static final String JAVAX_KEYSTORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_KEYSTORE_TYPE = "javax.net.ssl.keyStoreType";
    public static final String JAVAX_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_TRUSTSTORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_TRUSTSTORE_TYPE = "javax.net.ssl.trustStoreType";
    public static final String JAVAX_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String GEODE_SSL_CONFIG_PROPERTIES = "org.apache.geode.internal.net.ssl.config";
    @MakeNotStatic
    private static SSLConfigurationFactory instance = new SSLConfigurationFactory();

    private SSLConfigurationFactory() {
    }

    private static synchronized SSLConfigurationFactory getInstance() {
        if (instance == null) {
            instance = new SSLConfigurationFactory();
        }
        return instance;
    }

    private SSLConfig createSSLConfigForComponent(DistributionConfig distributionConfig, SecurableCommunicationChannel sslEnabledComponent) {
        SSLConfig.Builder sslConfigBuilder = this.createSSLConfigBuilder(distributionConfig, sslEnabledComponent);
        SecurableCommunicationChannel[] sslEnabledComponents = distributionConfig.getSecurableCommunicationChannels();
        if (sslEnabledComponents.length == 0) {
            this.configureLegacyClusterSSL(distributionConfig, sslConfigBuilder);
        }
        sslConfigBuilder.setSecurableCommunicationChannel(sslEnabledComponent);
        switch (sslEnabledComponent) {
            case ALL: {
                break;
            }
            case CLUSTER: {
                if (sslEnabledComponents.length > 0) {
                    this.setAliasForComponent(sslConfigBuilder, distributionConfig.getClusterSSLAlias());
                    break;
                }
                this.configureLegacyClusterSSL(distributionConfig, sslConfigBuilder);
                break;
            }
            case LOCATOR: {
                if (sslEnabledComponents.length <= 0) break;
                this.setAliasForComponent(sslConfigBuilder, distributionConfig.getLocatorSSLAlias());
                break;
            }
            case SERVER: {
                if (sslEnabledComponents.length > 0) {
                    this.setAliasForComponent(sslConfigBuilder, distributionConfig.getServerSSLAlias());
                    break;
                }
                this.configureLegacyServerSSL(distributionConfig, sslConfigBuilder);
                break;
            }
            case GATEWAY: {
                if (sslEnabledComponents.length > 0) {
                    this.setAliasForComponent(sslConfigBuilder, distributionConfig.getGatewaySSLAlias());
                    break;
                }
                this.configureLegacyGatewaySSL(distributionConfig, sslConfigBuilder);
                break;
            }
            case WEB: {
                if (sslEnabledComponents.length > 0) {
                    this.setAliasForComponent(sslConfigBuilder, distributionConfig.getHTTPServiceSSLAlias());
                    sslConfigBuilder.setRequireAuth(distributionConfig.getSSLWebRequireAuthentication());
                    break;
                }
                this.configureLegacyHttpServiceSSL(distributionConfig, sslConfigBuilder);
                break;
            }
            case JMX: {
                if (sslEnabledComponents.length > 0) {
                    this.setAliasForComponent(sslConfigBuilder, distributionConfig.getJMXSSLAlias());
                    break;
                }
                this.configureLegacyJMXSSL(distributionConfig, sslConfigBuilder);
            }
        }
        this.configureSSLPropertiesFromSystemProperties(sslConfigBuilder);
        return sslConfigBuilder.build();
    }

    private SSLConfig.Builder setAliasForComponent(SSLConfig.Builder sslConfigBuilder, String clusterSSLAlias) {
        if (!StringUtils.isEmpty((CharSequence)clusterSSLAlias)) {
            sslConfigBuilder.setAlias(clusterSSLAlias);
        }
        return sslConfigBuilder;
    }

    private SSLConfig.Builder createSSLConfigBuilder(DistributionConfig distributionConfig, SecurableCommunicationChannel sslEnabledComponent) {
        SSLConfig.Builder sslConfigBuilder = new SSLConfig.Builder();
        sslConfigBuilder.setCiphers(distributionConfig.getSSLCiphers());
        sslConfigBuilder.setEndpointIdentificationEnabled(distributionConfig.getSSLEndPointIdentificationEnabled());
        sslConfigBuilder.setEnabled(this.determineIfSSLEnabledForSSLComponent(distributionConfig, sslEnabledComponent));
        sslConfigBuilder.setKeystore(distributionConfig.getSSLKeyStore());
        sslConfigBuilder.setKeystorePassword(distributionConfig.getSSLKeyStorePassword());
        sslConfigBuilder.setKeystoreType(distributionConfig.getSSLKeyStoreType());
        sslConfigBuilder.setTruststore(distributionConfig.getSSLTrustStore());
        sslConfigBuilder.setTruststorePassword(distributionConfig.getSSLTrustStorePassword());
        sslConfigBuilder.setTruststoreType(distributionConfig.getSSLTrustStoreType());
        sslConfigBuilder.setProtocols(distributionConfig.getSSLProtocols());
        sslConfigBuilder.setRequireAuth(distributionConfig.getSSLRequireAuthentication());
        sslConfigBuilder.setAlias(distributionConfig.getSSLDefaultAlias());
        sslConfigBuilder.setUseDefaultSSLContext(distributionConfig.getSSLUseDefaultContext());
        sslConfigBuilder.setSSLParameterExtension(distributionConfig.getSSLParameterExtension());
        return sslConfigBuilder;
    }

    private boolean determineIfSSLEnabledForSSLComponent(DistributionConfig distributionConfig, SecurableCommunicationChannel sslEnabledComponent) {
        if (ArrayUtils.contains((Object[])distributionConfig.getSecurableCommunicationChannels(), (Object)((Object)SecurableCommunicationChannel.ALL))) {
            return true;
        }
        return ArrayUtils.contains((Object[])distributionConfig.getSecurableCommunicationChannels(), (Object)((Object)sslEnabledComponent));
    }

    private SSLConfig.Builder configureLegacyClusterSSL(DistributionConfig distributionConfig, SSLConfig.Builder sslConfigBuilder) {
        sslConfigBuilder.setCiphers(distributionConfig.getClusterSSLCiphers());
        sslConfigBuilder.setEnabled(distributionConfig.getClusterSSLEnabled());
        sslConfigBuilder.setKeystore(distributionConfig.getClusterSSLKeyStore());
        sslConfigBuilder.setKeystorePassword(distributionConfig.getClusterSSLKeyStorePassword());
        sslConfigBuilder.setKeystoreType(distributionConfig.getClusterSSLKeyStoreType());
        sslConfigBuilder.setTruststore(distributionConfig.getClusterSSLTrustStore());
        sslConfigBuilder.setTruststorePassword(distributionConfig.getClusterSSLTrustStorePassword());
        sslConfigBuilder.setTruststoreType(distributionConfig.getClusterSSLKeyStoreType());
        sslConfigBuilder.setProtocols(distributionConfig.getClusterSSLProtocols());
        sslConfigBuilder.setRequireAuth(distributionConfig.getClusterSSLRequireAuthentication());
        return sslConfigBuilder;
    }

    private SSLConfig.Builder configureLegacyServerSSL(DistributionConfig distributionConfig, SSLConfig.Builder sslConfigBuilder) {
        sslConfigBuilder.setCiphers(distributionConfig.getServerSSLCiphers());
        sslConfigBuilder.setEnabled(distributionConfig.getServerSSLEnabled());
        sslConfigBuilder.setKeystore(distributionConfig.getServerSSLKeyStore());
        sslConfigBuilder.setKeystorePassword(distributionConfig.getServerSSLKeyStorePassword());
        sslConfigBuilder.setKeystoreType(distributionConfig.getServerSSLKeyStoreType());
        sslConfigBuilder.setTruststore(distributionConfig.getServerSSLTrustStore());
        sslConfigBuilder.setTruststorePassword(distributionConfig.getServerSSLTrustStorePassword());
        sslConfigBuilder.setTruststoreType(distributionConfig.getServerSSLKeyStoreType());
        sslConfigBuilder.setProtocols(distributionConfig.getServerSSLProtocols());
        sslConfigBuilder.setRequireAuth(distributionConfig.getServerSSLRequireAuthentication());
        return sslConfigBuilder;
    }

    private SSLConfig.Builder configureLegacyJMXSSL(DistributionConfig distributionConfig, SSLConfig.Builder sslConfigBuilder) {
        sslConfigBuilder.setCiphers(distributionConfig.getJmxManagerSSLCiphers());
        sslConfigBuilder.setEnabled(distributionConfig.getJmxManagerSSLEnabled());
        sslConfigBuilder.setKeystore(distributionConfig.getJmxManagerSSLKeyStore());
        sslConfigBuilder.setKeystorePassword(distributionConfig.getJmxManagerSSLKeyStorePassword());
        sslConfigBuilder.setKeystoreType(distributionConfig.getJmxManagerSSLKeyStoreType());
        sslConfigBuilder.setTruststore(distributionConfig.getJmxManagerSSLTrustStore());
        sslConfigBuilder.setTruststorePassword(distributionConfig.getJmxManagerSSLTrustStorePassword());
        sslConfigBuilder.setTruststoreType(distributionConfig.getJmxManagerSSLKeyStoreType());
        sslConfigBuilder.setProtocols(distributionConfig.getJmxManagerSSLProtocols());
        sslConfigBuilder.setRequireAuth(distributionConfig.getJmxManagerSSLRequireAuthentication());
        return sslConfigBuilder;
    }

    private SSLConfig.Builder configureLegacyGatewaySSL(DistributionConfig distributionConfig, SSLConfig.Builder sslConfigBuilder) {
        sslConfigBuilder.setCiphers(distributionConfig.getGatewaySSLCiphers());
        sslConfigBuilder.setEnabled(distributionConfig.getGatewaySSLEnabled());
        sslConfigBuilder.setKeystore(distributionConfig.getGatewaySSLKeyStore());
        sslConfigBuilder.setKeystorePassword(distributionConfig.getGatewaySSLKeyStorePassword());
        sslConfigBuilder.setKeystoreType(distributionConfig.getGatewaySSLKeyStoreType());
        sslConfigBuilder.setTruststore(distributionConfig.getGatewaySSLTrustStore());
        sslConfigBuilder.setTruststorePassword(distributionConfig.getGatewaySSLTrustStorePassword());
        sslConfigBuilder.setProtocols(distributionConfig.getGatewaySSLProtocols());
        sslConfigBuilder.setRequireAuth(distributionConfig.getGatewaySSLRequireAuthentication());
        return sslConfigBuilder;
    }

    private SSLConfig.Builder configureLegacyHttpServiceSSL(DistributionConfig distributionConfig, SSLConfig.Builder sslConfigBuilder) {
        sslConfigBuilder.setCiphers(distributionConfig.getHttpServiceSSLCiphers());
        sslConfigBuilder.setEnabled(distributionConfig.getHttpServiceSSLEnabled());
        sslConfigBuilder.setKeystore(distributionConfig.getHttpServiceSSLKeyStore());
        sslConfigBuilder.setKeystorePassword(distributionConfig.getHttpServiceSSLKeyStorePassword());
        sslConfigBuilder.setKeystoreType(distributionConfig.getHttpServiceSSLKeyStoreType());
        sslConfigBuilder.setTruststore(distributionConfig.getHttpServiceSSLTrustStore());
        sslConfigBuilder.setTruststorePassword(distributionConfig.getHttpServiceSSLTrustStorePassword());
        sslConfigBuilder.setTruststoreType(distributionConfig.getHttpServiceSSLKeyStoreType());
        sslConfigBuilder.setProtocols(distributionConfig.getHttpServiceSSLProtocols());
        sslConfigBuilder.setRequireAuth(distributionConfig.getHttpServiceSSLRequireAuthentication());
        return sslConfigBuilder;
    }

    private SSLConfig.Builder configureSSLPropertiesFromSystemProperties(SSLConfig.Builder sslConfigBuilder) {
        return this.configureSSLPropertiesFromSystemProperties(sslConfigBuilder, null);
    }

    private SSLConfig.Builder configureSSLPropertiesFromSystemProperties(SSLConfig.Builder sslConfigBuilder, Properties properties) {
        if (StringUtils.isEmpty((CharSequence)sslConfigBuilder.getKeystore())) {
            sslConfigBuilder.setKeystore(this.getValueFromSystemProperties(properties, JAVAX_KEYSTORE));
        }
        if (StringUtils.isEmpty((CharSequence)sslConfigBuilder.getKeystoreType())) {
            sslConfigBuilder.setKeystoreType(this.getValueFromSystemProperties(properties, JAVAX_KEYSTORE_TYPE));
        }
        if (StringUtils.isEmpty((CharSequence)sslConfigBuilder.getKeystorePassword())) {
            sslConfigBuilder.setKeystorePassword(this.getValueFromSystemProperties(properties, JAVAX_KEYSTORE_PASSWORD));
        }
        if (StringUtils.isEmpty((CharSequence)sslConfigBuilder.getTruststore())) {
            sslConfigBuilder.setTruststore(this.getValueFromSystemProperties(properties, JAVAX_TRUSTSTORE));
        }
        if (StringUtils.isEmpty((CharSequence)sslConfigBuilder.getTruststorePassword())) {
            sslConfigBuilder.setTruststorePassword(this.getValueFromSystemProperties(properties, JAVAX_TRUSTSTORE_PASSWORD));
        }
        if (StringUtils.isEmpty((CharSequence)sslConfigBuilder.getTruststoreType())) {
            sslConfigBuilder.setTruststoreType(this.getValueFromSystemProperties(properties, JAVAX_TRUSTSTORE_TYPE));
        }
        return sslConfigBuilder;
    }

    private String getValueFromSystemProperties(Properties properties, String property) {
        String propertyValue = null;
        if (properties != null) {
            propertyValue = properties.getProperty(property);
        }
        if (property != null && (propertyValue = System.getProperty(property)) != null && propertyValue.trim().equals("")) {
            propertyValue = System.getenv(property);
        }
        return propertyValue;
    }

    @Deprecated
    public static SSLConfig getSSLConfigForComponent(boolean useSSL, boolean needClientAuth, String protocols, String ciphers, Properties gfsecurityProps, String alias) {
        SSLConfig.Builder sslConfigBuilder = new SSLConfig.Builder();
        sslConfigBuilder.setAlias(alias);
        sslConfigBuilder.setCiphers(ciphers);
        sslConfigBuilder.setProtocols(protocols);
        sslConfigBuilder.setRequireAuth(needClientAuth);
        sslConfigBuilder.setEnabled(useSSL);
        SSLConfigurationFactory.getInstance().configureSSLPropertiesFromSystemProperties(sslConfigBuilder, gfsecurityProps);
        return sslConfigBuilder.build();
    }

    public static SSLConfig getSSLConfigForComponent(DistributionConfig distributionConfig, SecurableCommunicationChannel sslEnabledComponent) {
        return SSLConfigurationFactory.getInstance().createSSLConfigForComponent(distributionConfig, sslEnabledComponent);
    }

    public static SSLConfig getSSLConfigForComponent(Properties properties, SecurableCommunicationChannel sslEnabledComponent) {
        return SSLConfigurationFactory.getInstance().createSSLConfigForComponent(new DistributionConfigImpl(properties), sslEnabledComponent);
    }
}

