/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import org.apache.geode.StatisticDescriptor;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.StatisticsType;
import org.apache.geode.StatisticsTypeFactory;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.statistics.StatisticsTypeFactoryImpl;

public class StatSamplerStats {
    public static final String SAMPLE_COUNT = "sampleCount";
    public static final String SAMPLE_TIME = "sampleTime";
    public static final String DELAY_DURATION = "delayDuration";
    public static final String STAT_RESOURCES = "statResources";
    public static final String JVM_PAUSES = "jvmPauses";
    public static final String SAMPLE_CALLBACKS = "sampleCallbacks";
    public static final String SAMPLE_CALLBACK_ERRORS = "sampleCallbackErrors";
    public static final String SAMPLE_CALLBACK_DURATION = "sampleCallbackDuration";
    @Immutable
    private static final StatisticsType samplerType;
    private static final int sampleCountId;
    private static final int sampleTimeId;
    private static final int delayDurationId;
    private static final int statResourcesId;
    private static final int jvmPausesId;
    private static final int sampleCallbacksId;
    private static final int sampleCallbackErrorsId;
    private static final int sampleCallbackDurationId;
    private final Statistics samplerStats;

    public StatSamplerStats(StatisticsFactory f, long id) {
        this.samplerStats = f.createStatistics(samplerType, "statSampler", id);
    }

    public void tookSample(long nanosSpentWorking, int statResources, long nanosSpentSleeping) {
        this.samplerStats.incInt(sampleCountId, 1);
        this.samplerStats.incLong(sampleTimeId, nanosSpentWorking / 1000000L);
        this.samplerStats.setInt(delayDurationId, (int)(nanosSpentSleeping / 1000000L));
        this.samplerStats.setInt(statResourcesId, statResources);
    }

    public void incJvmPauses() {
        this.samplerStats.incInt(jvmPausesId, 1);
    }

    public void incSampleCallbackErrors(int delta) {
        this.samplerStats.incInt(sampleCallbackErrorsId, delta);
    }

    public void setSampleCallbacks(int count) {
        this.samplerStats.setInt(sampleCallbacksId, count);
    }

    public void incSampleCallbackDuration(long delta) {
        this.samplerStats.incLong(sampleCallbackDurationId, delta);
    }

    public int getSampleCount() {
        return this.samplerStats.getInt(SAMPLE_COUNT);
    }

    public long getSampleTime() {
        return this.samplerStats.getLong(SAMPLE_TIME);
    }

    public int getDelayDuration() {
        return this.samplerStats.getInt(DELAY_DURATION);
    }

    public int getStatResources() {
        return this.samplerStats.getInt(STAT_RESOURCES);
    }

    public int getJvmPauses() {
        return this.samplerStats.getInt(JVM_PAUSES);
    }

    public void close() {
        this.samplerStats.close();
    }

    public Statistics getStats() {
        return this.samplerStats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("@").append(System.identityHashCode(this)).append("{");
        sb.append("isClosed=").append(this.samplerStats.isClosed());
        sb.append(", ").append("sampleCount=").append(this.samplerStats.getInt(SAMPLE_COUNT));
        sb.append(", ").append("sampleTime=").append(this.samplerStats.getLong(SAMPLE_TIME));
        sb.append(", ").append("delayDuration=").append(this.samplerStats.getInt(DELAY_DURATION));
        sb.append(", ").append("statResources=").append(this.samplerStats.getInt(STAT_RESOURCES));
        sb.append(", ").append("jvmPauses=").append(this.samplerStats.getInt(JVM_PAUSES));
        sb.append("}");
        return sb.toString();
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        samplerType = f.createType("StatSampler", "Stats on the statistic sampler.", new StatisticDescriptor[]{f.createIntCounter(SAMPLE_COUNT, "Total number of samples taken by this sampler.", "samples", false), f.createLongCounter(SAMPLE_TIME, "Total amount of time spent taking samples.", "milliseconds", false), f.createIntGauge(DELAY_DURATION, "Actual duration of sampling delay taken before taking this sample.", "milliseconds", false), f.createIntGauge(STAT_RESOURCES, "Current number of statistic resources being sampled by this sampler.", "resources", false), f.createIntCounter(JVM_PAUSES, "Total number of JVM pauses (which may or may not be full GC pauses) detected by this sampler. A JVM pause is defined as a system event which kept the statistics sampler thread from sampling for 3000 or more milliseconds. This threshold can be customized by setting the system property gemfire.statSamplerDelayThreshold (units are milliseconds).", JVM_PAUSES, false), f.createIntGauge(SAMPLE_CALLBACKS, "Current number of statistics that are sampled using callbacks.", "resources", false), f.createIntCounter(SAMPLE_CALLBACK_ERRORS, "Total number of exceptions thrown by callbacks when performing sampling", "errors", false), f.createLongCounter(SAMPLE_CALLBACK_DURATION, "Total amount of time invoking sampling callbacks", "milliseconds", false)});
        sampleCountId = samplerType.nameToId(SAMPLE_COUNT);
        sampleTimeId = samplerType.nameToId(SAMPLE_TIME);
        delayDurationId = samplerType.nameToId(DELAY_DURATION);
        statResourcesId = samplerType.nameToId(STAT_RESOURCES);
        jvmPausesId = samplerType.nameToId(JVM_PAUSES);
        sampleCallbacksId = samplerType.nameToId(SAMPLE_CALLBACKS);
        sampleCallbackErrorsId = samplerType.nameToId(SAMPLE_CALLBACK_ERRORS);
        sampleCallbackDurationId = samplerType.nameToId(SAMPLE_CALLBACK_DURATION);
    }
}

