/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.validators;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.GroupableConfiguration;
import org.apache.geode.management.configuration.RegionScoped;
import org.apache.geode.management.internal.configuration.mutators.CacheConfigurationManager;
import org.apache.geode.management.internal.exceptions.EntityExistsException;

public class MemberValidator {
    private ConfigurationPersistenceService persistenceService;
    private InternalCache cache;

    public MemberValidator(InternalCache cache, ConfigurationPersistenceService persistenceService) {
        this.cache = cache;
        this.persistenceService = persistenceService;
    }

    public void validateCreate(AbstractConfiguration config, CacheConfigurationManager manager) {
        Map<String, AbstractConfiguration> existingElementsAndTheirGroups = this.findCacheElement(config, manager);
        if (existingElementsAndTheirGroups.size() == 0) {
            return;
        }
        if (!(config instanceof GroupableConfiguration)) {
            throw new EntityExistsException(config.getClass().getSimpleName() + " '" + config.getId() + "' already exists");
        }
        String configGroup = AbstractConfiguration.getGroupName((String)config.getGroup());
        if (existingElementsAndTheirGroups.keySet().contains(configGroup)) {
            throw new EntityExistsException(config.getClass().getSimpleName() + " '" + config.getId() + "' already exists in group " + configGroup);
        }
        String[] groups = existingElementsAndTheirGroups.keySet().toArray(new String[0]);
        Set<DistributedMember> membersOfExistingGroups = this.findServers(groups);
        Set<DistributedMember> membersOfNewGroup = this.findServers(config.getGroup());
        HashSet<DistributedMember> intersection = new HashSet<DistributedMember>(membersOfExistingGroups);
        intersection.retainAll(membersOfNewGroup);
        if (intersection.size() > 0) {
            String members = intersection.stream().map(DistributedMember::getName).collect(Collectors.joining(", "));
            throw new EntityExistsException(config.getClass().getSimpleName() + " '" + config.getId() + "' already exists on member(s) " + members + ".");
        }
        for (Map.Entry<String, AbstractConfiguration> existing : existingElementsAndTheirGroups.entrySet()) {
            manager.checkCompatibility(config, existing.getKey(), existing.getValue());
        }
    }

    public String[] findGroupsWithThisElement(AbstractConfiguration config, CacheConfigurationManager manager) {
        return this.findCacheElement(config, manager).keySet().toArray(new String[0]);
    }

    public Map<String, AbstractConfiguration> findCacheElement(AbstractConfiguration config, CacheConfigurationManager manager) {
        HashMap<String, AbstractConfiguration> results = new HashMap<String, AbstractConfiguration>();
        for (String group : this.persistenceService.getGroups()) {
            CacheConfig cacheConfig = this.persistenceService.getCacheConfig(group, true);
            AbstractConfiguration existing = manager.get(config, cacheConfig);
            if (existing == null) continue;
            results.put(group, existing);
        }
        return results;
    }

    public Set<String> findGroups(String regionName) {
        HashSet<String> results = new HashSet<String>();
        Set<String> groups = this.persistenceService.getGroups();
        for (String group : groups) {
            CacheConfig existing = this.persistenceService.getCacheConfig(group, false);
            if (existing == null || existing.findRegionConfiguration(regionName) == null) continue;
            results.add(group);
        }
        return results;
    }

    public Set<DistributedMember> findServers(String ... groups) {
        return this.findMembers(false, groups);
    }

    public Set<DistributedMember> findServers(AbstractConfiguration configuration) {
        if (configuration instanceof RegionScoped) {
            Set<String> groups = this.findGroups(((RegionScoped)configuration).getRegionName());
            if (groups.size() == 0) {
                return Collections.emptySet();
            }
            return this.findServers(groups.toArray(new String[0]));
        }
        return this.findServers(configuration.getGroup());
    }

    public Set<DistributedMember> findMembers(String id, String ... groups) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return this.getAllServersAndLocators().stream().filter(m -> m.getName().equals(id)).collect(Collectors.toSet());
        }
        return this.findMembers(true, groups);
    }

    public Set<DistributedMember> findMembers(boolean includeLocators, String ... groups) {
        Set<DistributedMember> all;
        if (groups == null) {
            groups = new String[]{"cluster"};
        }
        if ((groups = (String[])Arrays.stream(groups).filter(Objects::nonNull).filter(s -> s.length() > 0).toArray(String[]::new)).length == 0) {
            groups = new String[]{"cluster"};
        }
        Set<DistributedMember> set = all = includeLocators ? this.getAllServersAndLocators() : this.getAllServers();
        if (Arrays.stream(groups).anyMatch(AbstractConfiguration::isCluster)) {
            return all;
        }
        HashSet<DistributedMember> matchingMembers = new HashSet<DistributedMember>();
        for (String group : groups) {
            matchingMembers.addAll(all.stream().filter(m -> m.getGroups() != null && m.getGroups().contains(group)).collect(Collectors.toSet()));
        }
        return matchingMembers;
    }

    Set<DistributedMember> getAllServers() {
        return this.cache.getDistributionManager().getNormalDistributionManagerIds().stream().map(DistributedMember.class::cast).collect(Collectors.toSet());
    }

    Set<DistributedMember> getAllServersAndLocators() {
        return this.cache.getDistributionManager().getDistributionManagerIds().stream().map(DistributedMember.class::cast).collect(Collectors.toSet());
    }
}

