/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.metrics.internal;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.noop.NoopCounter;
import io.micrometer.core.instrument.noop.NoopDistributionSummary;
import io.micrometer.core.instrument.noop.NoopFunctionCounter;
import io.micrometer.core.instrument.noop.NoopFunctionTimer;
import io.micrometer.core.instrument.noop.NoopGauge;
import io.micrometer.core.instrument.noop.NoopLongTaskTimer;
import io.micrometer.core.instrument.noop.NoopMeter;
import io.micrometer.core.instrument.noop.NoopTimer;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.Nullable;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;

@NonNullApi
public class NoopMeterRegistry
extends MeterRegistry {
    @Immutable
    @VisibleForTesting
    static final Clock NOOP_CLOCK = new Clock(){

        public long wallTime() {
            return 0L;
        }

        public long monotonicTime() {
            return 0L;
        }
    };

    public NoopMeterRegistry() {
        this(NOOP_CLOCK);
    }

    private NoopMeterRegistry(Clock clock) {
        super(clock);
    }

    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new NoopGauge(id);
    }

    protected Counter newCounter(Meter.Id id) {
        return new NoopCounter(id);
    }

    protected LongTaskTimer newLongTaskTimer(Meter.Id id) {
        return new NoopLongTaskTimer(id);
    }

    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        return new NoopTimer(id);
    }

    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        return new NoopDistributionSummary(id);
    }

    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new NoopMeter(id);
    }

    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new NoopFunctionTimer(id);
    }

    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new NoopFunctionCounter(id);
    }

    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.NONE;
    }
}

