/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.pdx.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Region;
import org.apache.geode.pdx.internal.EnumId;
import org.apache.geode.pdx.internal.EnumInfo;
import org.apache.geode.pdx.internal.PdxType;

public class PeerTypeRegistrationReverseMap {
    private final Map<PdxType, Integer> pendingTypeToId = Collections.synchronizedMap(new HashMap());
    private final Map<EnumInfo, EnumId> pendingEnumToId = Collections.synchronizedMap(new HashMap());
    private final Map<PdxType, Integer> typeToId = Collections.synchronizedMap(new HashMap());
    private final Map<EnumInfo, EnumId> enumToId = Collections.synchronizedMap(new HashMap());

    void save(Object key, Object value) {
        if (value instanceof PdxType) {
            PdxType type = (PdxType)value;
            this.typeToId.put(type, (Integer)key);
        } else if (value instanceof EnumInfo) {
            EnumInfo info = (EnumInfo)value;
            this.enumToId.put(info, (EnumId)key);
        }
    }

    void saveToPending(Object key, Object value) {
        if (value instanceof PdxType) {
            PdxType type = (PdxType)value;
            this.pendingTypeToId.put(type, (Integer)key);
        } else if (value instanceof EnumInfo) {
            EnumInfo info = (EnumInfo)value;
            this.pendingEnumToId.put(info, (EnumId)key);
        }
    }

    int typeToIdSize() {
        return this.typeToId.size();
    }

    int enumToIdSize() {
        return this.enumToId.size();
    }

    Integer getIdFromReverseMap(PdxType newType) {
        return this.typeToId.get(newType);
    }

    EnumId getIdFromReverseMap(EnumInfo newInfo) {
        return this.enumToId.get(newInfo);
    }

    boolean shouldReloadFromRegion(Region pdxRegion) {
        if (pdxRegion == null) {
            return false;
        }
        return this.typeToId.size() + this.pendingTypeToId.size() + this.enumToId.size() + this.pendingEnumToId.size() != pdxRegion.size();
    }

    void flushPendingReverseMap() {
        if (!this.pendingTypeToId.isEmpty()) {
            this.typeToId.putAll(this.pendingTypeToId);
            this.pendingTypeToId.clear();
        }
        if (!this.pendingEnumToId.isEmpty()) {
            this.enumToId.putAll(this.pendingEnumToId);
            this.pendingEnumToId.clear();
        }
    }

    void clear() {
        this.typeToId.clear();
        this.enumToId.clear();
        this.pendingTypeToId.clear();
        this.pendingEnumToId.clear();
    }

    @VisibleForTesting
    int pendingTypeToIdSize() {
        return this.pendingTypeToId.size();
    }

    @VisibleForTesting
    int pendingEnumToIdSize() {
        return this.pendingEnumToId.size();
    }
}

