/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.management.api.ClusterManagementResult;
import org.apache.geode.management.api.EntityGroupInfo;
import org.apache.geode.management.api.EntityInfo;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.runtime.RuntimeInfo;

@Experimental
public class ClusterManagementListResult<T extends AbstractConfiguration<R>, R extends RuntimeInfo>
extends ClusterManagementResult {
    private final Map<String, EntityInfo<T, R>> entities = new HashMap<String, EntityInfo<T, R>>();

    public ClusterManagementListResult() {
    }

    public ClusterManagementListResult(ClusterManagementResult.StatusCode statusCode, String message) {
        super(statusCode, message);
    }

    @JsonIgnore
    public List<EntityGroupInfo<T, R>> getEntityGroupInfo() {
        return this.entities.values().stream().flatMap(x -> x.getGroups().stream()).collect(Collectors.toList());
    }

    @JsonInclude
    public List<EntityInfo<T, R>> getResult() {
        return this.entities.values().stream().collect(Collectors.toList());
    }

    public void setResult(List<EntityInfo<T, R>> entities) {
        this.entities.clear();
        for (EntityInfo<T, R> entity : entities) {
            this.entities.put(entity.getId(), entity);
        }
    }

    public void addEntityInfo(EntityInfo<T, R> entityInfo) {
        this.entities.put(entityInfo.getId(), entityInfo);
    }

    @JsonIgnore
    public void setEntityGroupInfo(List<EntityGroupInfo<T, R>> entityGroupInfos) {
        this.entities.clear();
        for (EntityGroupInfo<T, R> entityGroupInfo : entityGroupInfos) {
            String id = ((AbstractConfiguration)entityGroupInfo.getConfiguration()).getId();
            EntityInfo<T, R> entity = this.entities.get(id);
            if (entity == null) {
                entity = new EntityInfo();
                entity.setId(id);
                this.entities.put(id, entity);
            }
            entity.getGroups().add(entityGroupInfo);
        }
    }

    @JsonIgnore
    public List<T> getConfigResult() {
        return this.getEntityGroupInfo().stream().map(EntityGroupInfo::getConfiguration).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<R> getRuntimeResult() {
        return this.getEntityGroupInfo().stream().flatMap(r -> r.getRuntimeInfo().stream()).collect(Collectors.toList());
    }
}

