/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testng.collections.Lists;

public final class GroupsHelper {
    private GroupsHelper() {
    }

    public static Map<String, String> createGroups(Map<String, List<String>> metaGroups, List<String> groups) {
        Map<String, String> result = new HashSet<String>(groups).stream().collect(Collectors.toMap(g -> g, g -> g));
        if (metaGroups.isEmpty()) {
            return result;
        }
        List<String> unfinishedGroups = Lists.newLinkedList();
        GroupsHelper.collectGroups(groups, unfinishedGroups, metaGroups, result);
        while (!unfinishedGroups.isEmpty()) {
            List<String> uGroups = Lists.newLinkedList(unfinishedGroups);
            unfinishedGroups = Lists.newLinkedList();
            GroupsHelper.collectGroups(uGroups, unfinishedGroups, metaGroups, result);
        }
        return result;
    }

    private static void collectGroups(List<String> groups, List<String> unfinishedGroups, Map<String, List<String>> metaGroups, Map<String, String> result) {
        for (String gn : groups) {
            List<String> subGroups = metaGroups.get(gn);
            if (subGroups == null) continue;
            for (String sg : subGroups) {
                if (null != result.get(sg)) continue;
                result.put(sg, sg);
                unfinishedGroups.add(sg);
            }
        }
    }
}

