/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.tunnel.websocket.tomcat;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.protocol.GuacamoleStatus;
import org.apache.guacamole.tunnel.TunnelRequest;
import org.apache.guacamole.tunnel.http.HTTPTunnelRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuacamoleWebSocketTunnelServlet
extends WebSocketServlet {
    private static final int BUFFER_SIZE = 8192;
    private static final String PING_OPCODE = "ping";
    private final Logger logger = LoggerFactory.getLogger(GuacamoleWebSocketTunnelServlet.class);

    private void closeConnection(WsOutbound outbound, int guacamoleStatusCode, int webSocketCode) {
        try {
            byte[] message = Integer.toString(guacamoleStatusCode).getBytes("UTF-8");
            outbound.close(webSocketCode, ByteBuffer.wrap(message));
        }
        catch (IOException e) {
            this.logger.debug("Unable to close WebSocket tunnel.", (Throwable)e);
        }
    }

    private void closeConnection(WsOutbound outbound, GuacamoleStatus guacStatus) {
        this.closeConnection(outbound, guacStatus.getGuacamoleStatusCode(), guacStatus.getWebSocketCode());
    }

    protected String selectSubProtocol(List<String> subProtocols) {
        for (String protocol : subProtocols) {
            if (!"guacamole".equals(protocol)) continue;
            return "guacamole";
        }
        return null;
    }

    public StreamInbound createWebSocketInbound(String protocol, HttpServletRequest request) {
        HTTPTunnelRequest tunnelRequest = new HTTPTunnelRequest(request);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected abstract GuacamoleTunnel doConnect(TunnelRequest var1) throws GuacamoleException;

    static /* synthetic */ Logger access$100(GuacamoleWebSocketTunnelServlet x0) {
        return x0.logger;
    }

    static /* synthetic */ void access$200(GuacamoleWebSocketTunnelServlet x0, WsOutbound x1, int x2, int x3) {
        x0.closeConnection(x1, x2, x3);
    }

    static /* synthetic */ void access$300(GuacamoleWebSocketTunnelServlet x0, WsOutbound x1, GuacamoleStatus x2) {
        x0.closeConnection(x1, x2);
    }
}

