/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.rule.builder;

import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ForallDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.rule.builder.PatternBuilder;
import org.drools.compiler.rule.builder.RuleBuildContext;
import org.drools.compiler.rule.builder.RuleConditionBuilder;
import org.drools.core.rule.Forall;
import org.drools.core.rule.GroupElement;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.RuleConditionElement;

public class ForallBuilder
implements RuleConditionBuilder {
    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr, Pattern prefixPattern) {
        return this.build(context, descr);
    }

    public RuleConditionElement build(RuleBuildContext context, BaseDescr descr) {
        PatternDescr p;
        ForallDescr forallDescr = (ForallDescr)descr;
        if (forallDescr.isSinglePattern()) {
            PatternDescr pattern = (PatternDescr)forallDescr.getDescrs().get(0);
            NotDescr notDescr = new NotDescr(pattern.negateConstraint());
            RuleConditionBuilder builder = (RuleConditionBuilder)context.getDialect().getBuilder(notDescr.getClass());
            return builder.build(context, notDescr);
        }
        BaseDescr selfJoin = forallDescr.getSelfJoinConstraint();
        if (selfJoin != null) {
            GroupElement transformedForall = new GroupElement();
            PatternDescr p1 = (PatternDescr)forallDescr.getDescrs().get(0);
            PatternDescr p2 = (PatternDescr)forallDescr.getDescrs().get(1);
            ExistsDescr existDescr = new ExistsDescr(p1);
            RuleConditionBuilder existsBuilder = (RuleConditionBuilder)context.getDialect().getBuilder(existDescr.getClass());
            transformedForall.addChild(existsBuilder.build(context, existDescr));
            NotDescr notDescr = new NotDescr(p1);
            p2.removeConstraint(selfJoin);
            p2.negateConstraint().getConstraint().getDescrs().forEach(p1::addConstraint);
            RuleConditionBuilder notBuilder = (RuleConditionBuilder)context.getDialect().getBuilder(notDescr.getClass());
            transformedForall.addChild(notBuilder.build(context, notDescr));
            return transformedForall;
        }
        PatternBuilder patternBuilder = (PatternBuilder)context.getDialect().getBuilder(PatternDescr.class);
        Pattern basePattern = (Pattern)patternBuilder.build(context, forallDescr.getBasePattern());
        if (basePattern == null) {
            return null;
        }
        Forall forall = new Forall(basePattern);
        context.getDeclarationResolver().pushOnBuildStack((RuleConditionElement)forall);
        for (BaseDescr baseDescr : forallDescr.getRemainingPatterns()) {
            Pattern anotherPattern = (Pattern)patternBuilder.build(context, (PatternDescr)baseDescr);
            forall.addRemainingPattern(anotherPattern);
        }
        if (forallDescr.getDescrs().size() == 1 && (p = (PatternDescr)forallDescr.getDescrs().get(0)).getConstraint().getDescrs().isEmpty()) {
            forall.setEmptyBetaConstraints(true);
        }
        context.getDeclarationResolver().popBuildStack();
        return forall;
    }
}

