/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.wrappers.streaming.io;

import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.flink.adapter.FlinkKey;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.values.ValueWithRecordId;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class DedupingOperator<@UnknownKeyFor T>
extends AbstractStreamOperator<WindowedValue<T>>
implements OneInputStreamOperator<WindowedValue<ValueWithRecordId<T>>, WindowedValue<T>>,
Triggerable<FlinkKey, VoidNamespace> {
    private static final @UnknownKeyFor @NonNull @Initialized long MAX_RETENTION_SINCE_ACCESS = Duration.standardMinutes((long)10L).getMillis();
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options;
    private @UnknownKeyFor @NonNull @Initialized ValueStateDescriptor<@UnknownKeyFor @NonNull @Initialized Long> dedupingStateDescriptor = new ValueStateDescriptor("dedup-cache", (TypeSerializer)LongSerializer.INSTANCE);
    private transient @UnknownKeyFor @NonNull @Initialized InternalTimerService<@UnknownKeyFor @NonNull @Initialized VoidNamespace> timerService;

    public DedupingOperator(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        this.options = new SerializablePipelineOptions(options);
    }

    public void initializeState(@UnknownKeyFor @NonNull @Initialized StateInitializationContext context) throws @UnknownKeyFor @NonNull @Initialized Exception {
        super.initializeState(context);
        this.timerService = this.getInternalTimerService("dedup-cleanup-timer", (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this);
    }

    public void open() {
        FileSystems.setDefaultPipelineOptions((PipelineOptions)this.options.get());
    }

    public void processElement(@UnknownKeyFor @NonNull @Initialized StreamRecord<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized ValueWithRecordId<T>>> streamRecord) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ValueState dedupingState = (ValueState)this.getPartitionedState((StateDescriptor)this.dedupingStateDescriptor);
        Long lastSeenTimestamp = (Long)dedupingState.value();
        if (lastSeenTimestamp == null) {
            WindowedValue value = (WindowedValue)streamRecord.getValue();
            this.output.collect((Object)streamRecord.replace((Object)value.withValue(((ValueWithRecordId)value.getValue()).getValue())));
        }
        long currentProcessingTime = this.timerService.currentProcessingTime();
        dedupingState.update((Object)currentProcessingTime);
        this.timerService.registerProcessingTimeTimer((Object)VoidNamespace.INSTANCE, currentProcessingTime + MAX_RETENTION_SINCE_ACCESS);
    }

    public void onEventTime(@UnknownKeyFor @NonNull @Initialized InternalTimer<@UnknownKeyFor @NonNull @Initialized FlinkKey, @UnknownKeyFor @NonNull @Initialized VoidNamespace> internalTimer) {
    }

    public void onProcessingTime(@UnknownKeyFor @NonNull @Initialized InternalTimer<@UnknownKeyFor @NonNull @Initialized FlinkKey, @UnknownKeyFor @NonNull @Initialized VoidNamespace> internalTimer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ValueState dedupingState = (ValueState)this.getPartitionedState((StateDescriptor)this.dedupingStateDescriptor);
        Long lastSeenTimestamp = (Long)dedupingState.value();
        if (lastSeenTimestamp != null && lastSeenTimestamp.equals(internalTimer.getTimestamp() - MAX_RETENTION_SINCE_ACCESS)) {
            dedupingState.clear();
        }
    }
}

