/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.streaming.api.functions.co.BroadcastProcessFunction;
import org.apache.flink.streaming.api.operators.BoundedMultiInput;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.streaming.api.operators.co.CoBroadcastWithNonKeyedOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;

@Internal
public class BatchCoBroadcastWithNonKeyedOperator<IN1, IN2, OUT>
extends CoBroadcastWithNonKeyedOperator<IN1, IN2, OUT>
implements BoundedMultiInput,
InputSelectable {
    private static final long serialVersionUID = -1869740381935471752L;
    private volatile transient boolean isBroadcastSideDone = false;

    public BatchCoBroadcastWithNonKeyedOperator(BroadcastProcessFunction<IN1, IN2, OUT> function, List<MapStateDescriptor<?, ?>> broadcastStateDescriptors) {
        super(function, broadcastStateDescriptors);
    }

    @Override
    public void endInput(int inputId) throws Exception {
        if (inputId == 2) {
            this.isBroadcastSideDone = true;
        }
    }

    @Override
    public InputSelection nextSelection() {
        if (!this.isBroadcastSideDone) {
            return InputSelection.SECOND;
        }
        return InputSelection.FIRST;
    }

    @Override
    public void processElement1(StreamRecord<IN1> element) throws Exception {
        Preconditions.checkState((boolean)this.isBroadcastSideDone, (Object)"Should not process regular input before broadcast side is done.");
        super.processElement1(element);
    }
}

