/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.www.service;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.NotePadMeta;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.www.service.WebService;
import org.apache.http.entity.ContentType;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WebServiceEditor
extends MetadataEditor<WebService> {
    private static final Class<?> PKG = WebServiceEditor.class;
    public static final String CONST_ERROR = "Error";
    private Text wName;
    private Button wEnabled;
    private TextVar wFilename;
    private MetaSelectionLine<PipelineRunConfiguration> wRunConfiguration;
    private TextVar wTransform;
    private TextVar wField;
    private TextVar wStatusCode;
    private ComboVar wContentType;
    private Button wListStatus;
    private TextVar wBodyContentVariable;
    private TextVar wHeaderContentVariable;

    public WebServiceEditor(HopGui hopGui, MetadataManager<WebService> manager, WebService metadata) {
        super(hopGui, manager, metadata);
    }

    @Override
    public void createControl(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        int middle = props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlIcon = new FormData();
        fdlIcon.top = new FormAttachment(0, 0);
        fdlIcon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlIcon);
        PropsUi.setLook((Widget)wIcon);
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.Name.Label", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment((Control)wIcon, margin);
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, 0, 0x1000000);
        fdName.left = new FormAttachment(middle, 0);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label spacer = new Label(parent, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Object lastControl = spacer;
        Label wlEnabled = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlEnabled);
        wlEnabled.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.Enabled.Label", (String[])new String[0]));
        FormData fdlEnabled = new FormData();
        fdlEnabled.left = new FormAttachment(0, 0);
        fdlEnabled.right = new FormAttachment(middle, -margin);
        fdlEnabled.top = new FormAttachment((Control)lastControl, margin);
        wlEnabled.setLayoutData((Object)fdlEnabled);
        this.wEnabled = new Button(parent, 16416);
        PropsUi.setLook((Widget)this.wEnabled);
        FormData fdEnabled = new FormData();
        fdEnabled.left = new FormAttachment(middle, 0);
        fdEnabled.right = new FormAttachment(100, 0);
        fdEnabled.top = new FormAttachment((Control)wlEnabled, 0, 0x1000000);
        this.wEnabled.setLayoutData((Object)fdEnabled);
        lastControl = wlEnabled;
        Label wlFilename = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlFilename);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.Filename.Label", (String[])new String[0]));
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, -margin);
        fdlFilename.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbbFilename = new Button(parent, 8);
        PropsUi.setLook((Widget)wbbFilename);
        wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbbFilename = new FormData();
        fdbbFilename.right = new FormAttachment(100, 0);
        fdbbFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wbbFilename.setLayoutData((Object)fdbbFilename);
        wbbFilename.addListener(13, e -> this.selectPipelineFilename(parent));
        Button wbnFilename = new Button(parent, 8);
        PropsUi.setLook((Widget)wbnFilename);
        wbnFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.New", (String[])new String[0]));
        FormData fdbnFilename = new FormData();
        fdbnFilename.right = new FormAttachment((Control)wbbFilename, -margin);
        fdbnFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wbnFilename.setLayoutData((Object)fdbnFilename);
        wbnFilename.addListener(13, e -> this.createPipelineFile(parent));
        Button wboFilename = new Button(parent, 8);
        PropsUi.setLook((Widget)wboFilename);
        wboFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Open", (String[])new String[0]));
        FormData fdboFilename = new FormData();
        fdboFilename.right = new FormAttachment((Control)wbnFilename, -margin);
        fdboFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        wboFilename.setLayoutData((Object)fdboFilename);
        wboFilename.addListener(13, e -> this.openPipelineFile(parent));
        this.wFilename = new TextVar(this.manager.getVariables(), parent, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment((Control)wboFilename, -margin);
        fdFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        this.wFilename.setLayoutData(fdFilename);
        lastControl = wlFilename;
        this.wRunConfiguration = new MetaSelectionLine<PipelineRunConfiguration>(this.manager.getVariables(), this.manager.getMetadataProvider(), PipelineRunConfiguration.class, parent, 0, BaseMessages.getString(PKG, (String)"WebServiceEditor.Runconfiguration.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WebServiceEditor.Runconfiguration.Tooltip", (String[])new String[0]));
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.left = new FormAttachment(0, 0);
        fdRunConfiguration.top = new FormAttachment((Control)lastControl, margin);
        fdRunConfiguration.right = new FormAttachment(100, 0);
        this.wRunConfiguration.setLayoutData(fdRunConfiguration);
        lastControl = this.wRunConfiguration;
        Label wlTransform = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlTransform);
        wlTransform.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.Transform.Label", (String[])new String[0]));
        FormData fdlTransform = new FormData();
        fdlTransform.left = new FormAttachment(0, 0);
        fdlTransform.right = new FormAttachment(middle, -margin);
        fdlTransform.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlTransform.setLayoutData((Object)fdlTransform);
        this.wTransform = new TextVar(this.manager.getVariables(), parent, 18436);
        PropsUi.setLook((Widget)this.wTransform);
        FormData fdTransform = new FormData();
        fdTransform.left = new FormAttachment(middle, 0);
        fdTransform.right = new FormAttachment(100, 0);
        fdTransform.top = new FormAttachment((Control)wlTransform, 0, 0x1000000);
        this.wTransform.setLayoutData(fdTransform);
        lastControl = wlTransform;
        Label wlField = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlField);
        wlField.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.Field.Label", (String[])new String[0]));
        FormData fdlField = new FormData();
        fdlField.left = new FormAttachment(0, 0);
        fdlField.right = new FormAttachment(middle, -margin);
        fdlField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlField.setLayoutData((Object)fdlField);
        this.wField = new TextVar(this.manager.getVariables(), parent, 18436);
        PropsUi.setLook((Widget)this.wField);
        FormData fdField = new FormData();
        fdField.left = new FormAttachment(middle, 0);
        fdField.right = new FormAttachment(100, 0);
        fdField.top = new FormAttachment((Control)wlField, 0, 0x1000000);
        this.wField.setLayoutData(fdField);
        lastControl = wlField;
        Label wlStatuscode = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlField);
        wlStatuscode.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.StatusCodeField.Label", (String[])new String[0]));
        FormData fdlStatusCode = new FormData();
        fdlStatusCode.left = new FormAttachment(0, 0);
        fdlStatusCode.right = new FormAttachment(middle, -margin);
        fdlStatusCode.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlStatuscode.setLayoutData((Object)fdlStatusCode);
        this.wStatusCode = new TextVar(this.manager.getVariables(), parent, 18436);
        PropsUi.setLook((Widget)this.wStatusCode);
        FormData fdStatuscode = new FormData();
        fdStatuscode.left = new FormAttachment(middle, 0);
        fdStatuscode.right = new FormAttachment(100, 0);
        fdStatuscode.top = new FormAttachment((Control)wlStatuscode, 0, 0x1000000);
        this.wStatusCode.setLayoutData(fdStatuscode);
        lastControl = wlStatuscode;
        Label wlContentType = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlContentType);
        wlContentType.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.ContentType.Label", (String[])new String[0]));
        FormData fdlContentType = new FormData();
        fdlContentType.left = new FormAttachment(0, 0);
        fdlContentType.right = new FormAttachment(middle, -margin);
        fdlContentType.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlContentType.setLayoutData((Object)fdlContentType);
        this.wContentType = new ComboVar(this.manager.getVariables(), parent, 18432);
        PropsUi.setLook((Widget)this.wContentType);
        FormData fdContentType = new FormData();
        fdContentType.left = new FormAttachment(middle, 0);
        fdContentType.right = new FormAttachment(100, 0);
        fdContentType.top = new FormAttachment((Control)wlContentType, 0, 0x1000000);
        this.wContentType.setLayoutData(fdContentType);
        this.wContentType.add(ContentType.TEXT_PLAIN.getMimeType());
        this.wContentType.add(ContentType.APPLICATION_JSON.getMimeType());
        this.wContentType.add(ContentType.APPLICATION_XML.getMimeType());
        this.wContentType.add(ContentType.TEXT_HTML.getMimeType());
        lastControl = wlContentType;
        Label wlListStatus = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlListStatus);
        wlListStatus.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.ListStatus.Label", (String[])new String[0]));
        FormData fdlListStatus = new FormData();
        fdlListStatus.left = new FormAttachment(0, 0);
        fdlListStatus.right = new FormAttachment(middle, -margin);
        fdlListStatus.top = new FormAttachment((Control)lastControl, margin);
        wlListStatus.setLayoutData((Object)fdlListStatus);
        this.wListStatus = new Button(parent, 16416);
        PropsUi.setLook((Widget)this.wListStatus);
        FormData fdListStatus = new FormData();
        fdListStatus.left = new FormAttachment(middle, 0);
        fdListStatus.right = new FormAttachment(100, 0);
        fdListStatus.top = new FormAttachment((Control)wlListStatus, 0, 0x1000000);
        this.wListStatus.setLayoutData((Object)fdListStatus);
        lastControl = this.wListStatus;
        Label wlBodyContentVariable = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlBodyContentVariable);
        wlBodyContentVariable.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.BodyContentVariable.Label", (String[])new String[0]));
        wlBodyContentVariable.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceEditor.BodyContentVariable.Tooltip", (String[])new String[0]));
        FormData fdlBodyContentVariable = new FormData();
        fdlBodyContentVariable.left = new FormAttachment(0, 0);
        fdlBodyContentVariable.right = new FormAttachment(middle, -margin);
        fdlBodyContentVariable.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlBodyContentVariable.setLayoutData((Object)fdlBodyContentVariable);
        this.wBodyContentVariable = new TextVar(this.manager.getVariables(), parent, 18436);
        this.wBodyContentVariable.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceEditor.BodyContentVariable.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wBodyContentVariable);
        FormData fdBodyContentVariable = new FormData();
        fdBodyContentVariable.left = new FormAttachment(middle, 0);
        fdBodyContentVariable.right = new FormAttachment(100, 0);
        fdBodyContentVariable.top = new FormAttachment((Control)wlBodyContentVariable, 0, 0x1000000);
        this.wBodyContentVariable.setLayoutData(fdBodyContentVariable);
        lastControl = wlBodyContentVariable;
        Label wlHeaderContentVariable = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlHeaderContentVariable);
        wlHeaderContentVariable.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.HeaderContentVariable.Label", (String[])new String[0]));
        wlHeaderContentVariable.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceEditor.HeaderContentVariable.Tooltip", (String[])new String[0]));
        FormData fdlHeaderContentVariable = new FormData();
        fdlHeaderContentVariable.left = new FormAttachment(0, 0);
        fdlHeaderContentVariable.right = new FormAttachment(middle, -margin);
        fdlHeaderContentVariable.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlHeaderContentVariable.setLayoutData((Object)fdlHeaderContentVariable);
        this.wHeaderContentVariable = new TextVar(this.manager.getVariables(), parent, 18436);
        this.wHeaderContentVariable.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceEditor.HeaderContentVariable.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wHeaderContentVariable);
        FormData fdHeaderContentVariable = new FormData();
        fdHeaderContentVariable.left = new FormAttachment(middle, 0);
        fdHeaderContentVariable.right = new FormAttachment(100, 0);
        fdHeaderContentVariable.top = new FormAttachment((Control)wlHeaderContentVariable, 0, 0x1000000);
        this.wHeaderContentVariable.setLayoutData(fdHeaderContentVariable);
        lastControl = wlHeaderContentVariable;
        this.setWidgetsContent();
        Listener modifyListener = e -> this.setChanged();
        this.wName.addListener(24, modifyListener);
        this.wEnabled.addListener(13, modifyListener);
        this.wFilename.addListener(24, modifyListener);
        this.wTransform.addListener(24, modifyListener);
        this.wField.addListener(24, modifyListener);
        this.wStatusCode.addListener(24, modifyListener);
        this.wContentType.addListener(24, modifyListener);
        this.wListStatus.addListener(13, modifyListener);
        this.wBodyContentVariable.addListener(24, modifyListener);
        this.wHeaderContentVariable.addListener(24, modifyListener);
        this.wRunConfiguration.addListener(13, modifyListener);
    }

    private void createPipelineFile(Composite parent) {
        try {
            PipelineMeta pipelineMeta = new PipelineMeta();
            NotePadMeta note = new NotePadMeta("This pipeline can create output for a web service." + Const.CR + "It will pick up the data in a single field in a single transform of this pipeline", 150, 350, -1, -1);
            pipelineMeta.addNote(note);
            HopPipelineFileType type = new HopPipelineFileType();
            String filename = BaseDialog.presentFileDialog(true, parent.getShell(), this.wFilename, this.manager.getVariables(), type.getFilterExtensions(), type.getFilterNames(), true);
            if (filename != null) {
                String realFilename = this.manager.getVariables().resolve(filename);
                pipelineMeta.setFilename(realFilename);
                pipelineMeta.clearChanged();
                HopGui.getExplorerPerspective().addPipeline(pipelineMeta);
                HopGui.getExplorerPerspective().activate();
                this.hopGui.fileDelegate.fileSave();
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent.getShell(), CONST_ERROR, "Error creating pipeline", e);
        }
    }

    private void openPipelineFile(Composite parent) {
        try {
            String filename = this.manager.getVariables().resolve(this.wFilename.getText());
            if (StringUtils.isNotEmpty((String)filename)) {
                this.hopGui.fileDelegate.fileOpen(filename);
            }
        }
        catch (Exception e) {
            new ErrorDialog(parent.getShell(), CONST_ERROR, "Error creating pipeline", e);
        }
    }

    private void selectPipelineFilename(Composite parent) {
        HopPipelineFileType type = new HopPipelineFileType();
        BaseDialog.presentFileDialog(parent.getShell(), this.wFilename, this.manager.getVariables(), type.getFilterExtensions(), type.getFilterNames(), true);
    }

    @Override
    public void setWidgetsContent() {
        WebService ws = (WebService)this.getMetadata();
        this.wName.setText(Const.NVL((String)ws.getName(), (String)""));
        this.wEnabled.setSelection(ws.isEnabled());
        this.wFilename.setText(Const.NVL((String)ws.getFilename(), (String)""));
        this.wTransform.setText(Const.NVL((String)ws.getTransformName(), (String)""));
        this.wField.setText(Const.NVL((String)ws.getFieldName(), (String)""));
        this.wStatusCode.setText(Const.NVL((String)ws.getStatusCode(), (String)""));
        this.wContentType.setText(Const.NVL((String)ws.getContentType(), (String)""));
        this.wListStatus.setSelection(ws.isListingStatus());
        this.wBodyContentVariable.setText(Const.NVL((String)ws.getBodyContentVariable(), (String)""));
        this.wHeaderContentVariable.setText(Const.NVL((String)ws.getHeaderContentVariable(), (String)""));
        try {
            this.wRunConfiguration.fillItems();
            this.wRunConfiguration.setText(Const.NVL((String)ws.getRunConfigurationName(), (String)""));
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting workflow run configurations", (Throwable)e);
        }
    }

    @Override
    public void getWidgetsContent(WebService ws) {
        ws.setName(this.wName.getText());
        ws.setEnabled(this.wEnabled.getSelection());
        ws.setFilename(this.wFilename.getText());
        ws.setTransformName(this.wTransform.getText());
        ws.setFieldName(this.wField.getText());
        ws.setStatusCode(this.wStatusCode.getText());
        ws.setContentType(this.wContentType.getText());
        ws.setListingStatus(this.wListStatus.getSelection());
        ws.setBodyContentVariable(this.wBodyContentVariable.getText());
        ws.setHeaderContentVariable(this.wHeaderContentVariable.getText());
        ws.setRunConfigurationName(this.wRunConfiguration.getText());
    }

    @Override
    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }

    @Override
    public Button[] createButtonsForButtonBar(Composite composite) {
        Button wSelect = new Button(composite, 8);
        wSelect.setText(BaseMessages.getString(PKG, (String)"WebServiceEditor.SelectOutput.Button", (String[])new String[0]));
        wSelect.addListener(13, e -> this.selectOutputField());
        return new Button[]{wSelect};
    }

    private void selectOutputField() {
        IVariables variables = this.manager.getVariables();
        IHopMetadataProvider metadataProvider = this.manager.getMetadataProvider();
        String filename = variables.resolve(this.wFilename.getText());
        try {
            PipelineMeta pipelineMeta = new PipelineMeta(filename, metadataProvider, variables);
            EnterSelectionDialog selectTransformDialog = new EnterSelectionDialog(this.hopGui.getActiveShell(), pipelineMeta.getTransformNames(), "Select output transform", "Select the transform output for the web service");
            String transformName = selectTransformDialog.open();
            if (transformName == null) {
                return;
            }
            IRowMeta rowMeta = pipelineMeta.getTransformFields(variables, transformName);
            EnterSelectionDialog selectFieldDialog = new EnterSelectionDialog(this.hopGui.getActiveShell(), rowMeta.getFieldNames(), "Select the output field", "Select the field to use as output for this web service");
            String fieldName = selectFieldDialog.open();
            if (fieldName == null) {
                return;
            }
            this.wTransform.setText(transformName);
            this.wField.setText(fieldName);
        }
        catch (Exception e) {
            new ErrorDialog(this.hopGui.getActiveShell(), CONST_ERROR, "Error selecting output field", e);
        }
    }
}

