/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.rest.handler.RestHandlerSpecification;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelInboundHandler;
import org.apache.flink.util.AutoCloseableAsync;

public interface WebMonitorExtension
extends AutoCloseableAsync {
    public Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> getHandlers();

    public static WebMonitorExtension empty() {
        return EmptyWebMonitorExtension.INSTANCE;
    }

    public static enum EmptyWebMonitorExtension implements WebMonitorExtension
    {
        INSTANCE;


        @Override
        public Collection<Tuple2<RestHandlerSpecification, ChannelInboundHandler>> getHandlers() {
            return Collections.emptyList();
        }

        public CompletableFuture<Void> closeAsync() {
            return CompletableFuture.completedFuture(null);
        }
    }
}

