/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.deque;

import org.psjava.ds.deque.Deque;
import org.psjava.util.AssertStatus;
import org.psjava.util.Java1DArray;
import org.psjava.util.ZeroTo;

public class DynamicArrayDeque<T>
implements Deque<T> {
    protected Object[] array = Java1DArray.create(Object.class, 1);
    protected int start = 0;
    protected int end = 0;

    public static <T> DynamicArrayDeque<T> create() {
        return new DynamicArrayDeque<T>();
    }

    @Override
    public void addToLast(T e) {
        this.array[this.end] = e;
        this.end = (this.end + 1) % this.array.length;
        if (this.start == this.end) {
            this.handleFullEvent();
        }
    }

    @Override
    public void addToFirst(T v) {
        this.start = (this.start - 1 + this.array.length) % this.array.length;
        this.array[this.start] = v;
        if (this.start == this.end) {
            this.handleFullEvent();
        }
    }

    private void handleFullEvent() {
        T[] newArray = Java1DArray.create(Object.class, this.array.length * 2);
        for (int i : ZeroTo.get(this.array.length)) {
            newArray[i] = this.array[(this.start + i) % this.array.length];
        }
        this.start = 0;
        this.end = this.array.length;
        this.array = newArray;
    }

    @Override
    public void clear() {
        this.start = 0;
        this.end = 0;
    }

    @Override
    public T getFirst() {
        AssertStatus.assertTrue(!this.isEmpty());
        return (T)this.array[this.start];
    }

    @Override
    public T getLast() {
        AssertStatus.assertTrue(!this.isEmpty());
        return (T)this.array[(this.end - 1 + this.array.length) % this.array.length];
    }

    @Override
    public boolean isEmpty() {
        return this.start == this.end;
    }

    @Override
    public T removeFirst() {
        AssertStatus.assertTrue(!this.isEmpty());
        Object r = this.array[this.start];
        this.start = (this.start + 1) % this.array.length;
        return (T)r;
    }

    @Override
    public T removeLast() {
        AssertStatus.assertTrue(!this.isEmpty());
        this.end = (this.end - 1 + this.array.length) % this.array.length;
        return (T)this.array[this.end];
    }
}

