/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;

class LicenseBaseRequest
extends ClientAccessDataStream {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    protected CharConverter conv_;
    static final int PRODUCT_ID_CCSID_LOCATION = 22;
    static final int PRODUCT_ID_LOCATION = 26;
    static final int FEATURE_CCSID_LOCATION = 33;
    static final int FEATURE_LOCATION = 37;
    static final int RELEASE_CCSID_LOCATION = 41;
    static final int RELEASE_LOCATION = 45;

    LicenseBaseRequest(int size, AS400 system) {
        block5: {
            int i;
            this.data_ = new byte[size];
            this.setLength(size);
            this.setHeaderID(0);
            this.setServerID(57344);
            this.setCSInstance(0);
            this.setCorrelation(0);
            this.setTemplateLen(size - 20);
            this.set16bit(0, 20);
            for (i = 0; i < 7; ++i) {
                this.data_[26 + i] = 64;
            }
            for (i = 0; i < 4; ++i) {
                this.data_[37 + i] = 64;
            }
            for (i = 0; i < 6; ++i) {
                this.data_[45 + i] = 64;
            }
            this.set32bit(37, 22);
            this.set32bit(37, 33);
            this.set32bit(37, 41);
            try {
                this.conv_ = new CharConverter(37, system);
            }
            catch (UnsupportedEncodingException exc) {
                if (!Trace.isTraceOn()) break block5;
                Trace.log(2, "Unsupported encoding exception - CCSID 37.");
            }
        }
        this.set16bit(0, size - 2);
    }

    void setProductID(String productID) {
        block2: {
            try {
                this.conv_.stringToByteArray(productID, this.data_, 26, 7);
            }
            catch (CharConversionException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Character conversion exception - productID: " + productID);
            }
        }
    }

    void setFeature(String feature) {
        block2: {
            try {
                this.conv_.stringToByteArray(feature, this.data_, 37, 4);
            }
            catch (CharConversionException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Character conversion exception - feature: " + feature);
            }
        }
    }

    void setRelease(String release) {
        block2: {
            try {
                this.conv_.stringToByteArray(release, this.data_, 45, 6);
            }
            catch (CharConversionException e) {
                if (!Trace.isTraceOn()) break block2;
                Trace.log(2, "Character conversion exception - release: " + release);
            }
        }
    }
}

