/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Job;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ObjectList;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.SystemPool;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class Subsystem {
    static final long serialVersionUID = 4L;
    private static final boolean DEBUG = false;
    private static final String NO_MESSAGES_RETURNED = "No messages returned from failed command.";
    private static final String REFRESH_METHOD_NOT_YET_CALLED = "The refresh() method has not yet been called.";
    public static final int NO_MAX = -1;
    public static final int NO_TIME_LIMIT = -1;
    private AS400 system_;
    private String path_;
    private String name_;
    private String library_;
    private String extendedStatus_;
    private int maxActiveJobs_;
    private int currentActiveJobs_;
    private String monitorJobName_;
    private String monitorJobUser_;
    private String monitorJobNumber_;
    private String descriptionText_;
    private String dspFileName_;
    private String dspFileLibrary_;
    private String langLibrary_;
    private SystemPool[] pools_;
    private transient ObjectDescription objectDescription_;
    private transient boolean refreshed_;

    public Subsystem(AS400 system, String library, String name) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.system_ = system;
        this.path_ = QSYSObjectPathName.toPath(library, name, "SBSD");
        this.library_ = library;
        this.name_ = name;
    }

    public Subsystem(AS400 system, String path) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (path == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qsys = new QSYSObjectPathName(path);
        if (!qsys.getObjectType().equalsIgnoreCase("SBSD")) {
            throw new ExtendedIllegalArgumentException("path", 2);
        }
        this.system_ = system;
        this.path_ = path;
        this.library_ = qsys.getLibraryName();
        this.name_ = qsys.getObjectName();
    }

    public void assignPool(int sequenceNumber, String poolName) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (poolName == null) {
            throw new NullPointerException("poolName");
        }
        if (sequenceNumber < 1 || sequenceNumber > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber", 4);
        }
        CommandCall cmd = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") POOLS((" + sequenceNumber + " " + poolName + "))");
        if (!cmd.run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                throw new AS400Exception(msgs);
            }
            Trace.log(2, NO_MESSAGES_RETURNED);
            throw new InternalErrorException(6);
        }
    }

    public void assignPool(int sequenceNumber, int size, int activityLevel) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (sequenceNumber < 1 || sequenceNumber > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber", 4);
        }
        CommandCall cmd = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") POOLS((" + sequenceNumber + " " + size + " " + activityLevel + "))");
        if (!cmd.run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                throw new AS400Exception(msgs);
            }
            Trace.log(2, NO_MESSAGES_RETURNED);
            throw new InternalErrorException(6);
        }
    }

    public void changeDescriptionText(String text) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall cmd;
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (text.length() == 0) {
            text = "*BLANK";
        }
        if (!(cmd = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") TEXT('" + text + "')")).run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                throw new AS400Exception(msgs);
            }
            Trace.log(2, NO_MESSAGES_RETURNED);
            throw new InternalErrorException(6);
        }
    }

    public void changeDisplayFilePath(String path) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (path == null) {
            throw new NullPointerException("path");
        }
        QSYSObjectPathName qpath = new QSYSObjectPathName(path);
        CommandCall cmd = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") SGNDSPF(" + qpath.getLibraryName() + "/" + qpath.getObjectName() + ")");
        if (!cmd.run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                throw new AS400Exception(msgs);
            }
            Trace.log(2, NO_MESSAGES_RETURNED);
            throw new InternalErrorException(6);
        }
    }

    public void changeLanguageLibrary(String library) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall cmd;
        if (library == null) {
            throw new NullPointerException("library");
        }
        if (library.trim().length() == 0) {
            library = "*NONE";
        }
        if (!(cmd = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") SYSLIBLE(" + library + ")")).run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                throw new AS400Exception(msgs);
            }
            Trace.log(2, NO_MESSAGES_RETURNED);
            throw new InternalErrorException(6);
        }
    }

    public void changeMaximumActiveJobs(int maxJobs) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        String max = maxJobs == -1 ? "*NOMAX" : Integer.toString(maxJobs);
        CommandCall cmd = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") MAXJOBS(" + max + ")");
        if (!cmd.run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                throw new AS400Exception(msgs);
            }
            Trace.log(2, NO_MESSAGES_RETURNED);
            throw new InternalErrorException(6);
        }
    }

    public void create() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        this.create("*LIBCRTAUT");
    }

    public void create(String authority) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, ObjectAlreadyExistsException {
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        if (this.exists()) {
            throw new ObjectAlreadyExistsException(this.path_, 1);
        }
        String cmdString = "QSYS/CRTSBSD SBSD(" + this.library_ + "/" + this.name_ + ") AUT(" + authority + ") POOLS((1 *BASE))";
        CommandCall cmd = new CommandCall(this.system_, cmdString);
        if (!cmd.run()) {
            throw new AS400Exception(cmd.getMessageList());
        }
    }

    public void delete() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        CommandCall cmd = new CommandCall(this.system_, "QSYS/DLTSBSD SBSD(" + this.library_ + "/" + this.name_ + ")");
        if (!cmd.run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                if (msgs[0].getID() != null && !msgs[0].getID().equals("CPF2105") && !msgs[0].getID().equals("CPF2110")) {
                    throw new AS400Exception(msgs);
                }
            } else {
                Trace.log(2, NO_MESSAGES_RETURNED);
                throw new InternalErrorException(6);
            }
        }
    }

    public void end(int timeLimit) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Subsystem.end(this.system_, this.name_, false, timeLimit);
    }

    public static void endAllSubsystems(AS400 system, int timeLimit) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        Subsystem.end(system, "*ALL", false, timeLimit);
    }

    public static void endAllSubsystemsImmediately(AS400 system) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        if (system == null) {
            throw new NullPointerException("system");
        }
        Subsystem.end(system, "*ALL", true, -1);
    }

    public void endImmediately() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        Subsystem.end(this.system_, this.name_, true, -1);
    }

    public boolean equals(Object obj) {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        if (obj == null) {
            return false;
        }
        try {
            Subsystem other = (Subsystem)obj;
            if (!this.system_.equals(other.getSystem())) {
                return false;
            }
            if (!this.library_.equals(other.getLibrary())) {
                return false;
            }
            return this.name_.equals(other.getName());
        }
        catch (Throwable e) {
            return false;
        }
    }

    public int hashCode() {
        return this.system_.hashCode() + this.library_.hashCode() + this.name_.hashCode();
    }

    public boolean exists() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_.exists();
    }

    public int getCurrentActiveJobs() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        return this.currentActiveJobs_;
    }

    public String getDescriptionText() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        return this.descriptionText_;
    }

    public String getDisplayFilePath() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        if (this.dspFileLibrary_ == null) {
            return null;
        }
        return QSYSObjectPathName.toPath(this.dspFileLibrary_, this.dspFileName_, "FILE");
    }

    public String getLanguageLibrary() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        return this.langLibrary_;
    }

    public String getLibrary() {
        return this.library_;
    }

    public int getMaximumActiveJobs() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        return this.maxActiveJobs_;
    }

    public Job getMonitorJob() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        if (this.monitorJobName_ == null || this.monitorJobUser_ == null || this.monitorJobNumber_ == null || this.monitorJobName_.length() == 0) {
            return null;
        }
        return new Job(this.system_, this.monitorJobName_, this.monitorJobUser_, this.monitorJobNumber_);
    }

    public String getName() {
        return this.name_;
    }

    public ObjectDescription getObjectDescription() {
        if (this.objectDescription_ == null) {
            this.objectDescription_ = this.getObjDesc();
        }
        return this.objectDescription_;
    }

    public String getPath() {
        return this.path_;
    }

    public SystemPool getPool(int sequenceNumber) {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        if (sequenceNumber < 1 || sequenceNumber > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber", 4);
        }
        return this.pools_[sequenceNumber - 1];
    }

    public SystemPool[] getPools() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        return this.pools_;
    }

    public String getStatus() {
        if (Trace.isTraceOn() && !this.refreshed_) {
            Trace.log(4, REFRESH_METHOD_NOT_YET_CALLED);
        }
        return this.extendedStatus_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public static Subsystem[] listAllSubsystems(AS400 system) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, RequestNotSupportedException {
        Vector<Subsystem> sbsList = new Vector<Subsystem>(20);
        ObjectList objList = new ObjectList(system, "*ALL", "*ALL", "*SBSD");
        Enumeration list = objList.getObjects();
        while (list.hasMoreElements()) {
            ObjectDescription objDesc = (ObjectDescription)list.nextElement();
            Subsystem sbs = new Subsystem(system, objDesc.getPath());
            sbsList.addElement(sbs);
        }
        Subsystem[] sbsArray = new Subsystem[sbsList.size()];
        sbsList.toArray(sbsArray);
        return sbsArray;
    }

    public synchronized void refresh() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        try {
            int i;
            ProgramParameter[] parms = new ProgramParameter[5];
            int outputSize = 200;
            parms[0] = new ProgramParameter(outputSize);
            parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(outputSize));
            parms[2] = new ProgramParameter(conv.stringToByteArray("SBSI0200"));
            QSYSObjectPathName qsys = new QSYSObjectPathName(this.path_);
            AS400Text text10 = new AS400Text(10, ccsid);
            byte[] qualifiedSubsystemName = new byte[20];
            text10.toBytes(qsys.getObjectName(), qualifiedSubsystemName, 0);
            text10.toBytes(qsys.getLibraryName(), qualifiedSubsystemName, 10);
            parms[3] = new ProgramParameter(qualifiedSubsystemName);
            parms[4] = new ProgramParameter(new byte[4]);
            ProgramCall pc = new ProgramCall(this.system_, "/QSYS.LIB/QWDRSBSD.PGM", parms);
            pc.suggestThreadsafe();
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            byte[] data = parms[0].getOutputData();
            int bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
            int bytesAvailable = BinaryConverter.byteArrayToInt(data, 4);
            while (bytesReturned < bytesAvailable) {
                parms[0].setOutputDataLength(outputSize += bytesAvailable * 2);
                parms[1].setInputData(BinaryConverter.intToByteArray(outputSize));
                if (!pc.run()) {
                    throw new AS400Exception(pc.getMessageList());
                }
                data = parms[0].getOutputData();
                bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
                bytesAvailable = BinaryConverter.byteArrayToInt(data, 4);
            }
            int offset = BinaryConverter.byteArrayToInt(data, 8);
            this.name_ = conv.byteArrayToString(data, offset, 10).trim();
            this.library_ = conv.byteArrayToString(data, offset + 10, 10).trim();
            this.extendedStatus_ = conv.byteArrayToString(data, offset + 20, 12).trim();
            this.maxActiveJobs_ = BinaryConverter.byteArrayToInt(data, offset + 32);
            this.currentActiveJobs_ = BinaryConverter.byteArrayToInt(data, offset + 36);
            this.monitorJobName_ = conv.byteArrayToString(data, offset + 40, 10).trim();
            this.monitorJobUser_ = conv.byteArrayToString(data, offset + 50, 10).trim();
            this.monitorJobNumber_ = conv.byteArrayToString(data, offset + 60, 6).trim();
            this.descriptionText_ = conv.byteArrayToString(data, offset + 66, 50).trim();
            outputSize = 500;
            parms[0] = new ProgramParameter(outputSize);
            parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(outputSize));
            parms[2] = new ProgramParameter(conv.stringToByteArray("SBSI0100"));
            pc.setParameterList(parms);
            if (!pc.run()) {
                throw new AS400Exception(pc.getMessageList());
            }
            data = parms[0].getOutputData();
            bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
            bytesAvailable = BinaryConverter.byteArrayToInt(data, 4);
            while (bytesReturned < bytesAvailable) {
                parms[0].setOutputDataLength(outputSize += bytesAvailable * 2);
                parms[1].setInputData(BinaryConverter.intToByteArray(outputSize));
                if (!pc.run()) {
                    throw new AS400Exception(pc.getMessageList());
                }
                data = parms[0].getOutputData();
                bytesReturned = BinaryConverter.byteArrayToInt(data, 0);
                bytesAvailable = BinaryConverter.byteArrayToInt(data, 4);
            }
            this.dspFileName_ = conv.byteArrayToString(data, 38, 10).trim();
            this.dspFileLibrary_ = conv.byteArrayToString(data, 48, 10).trim();
            this.langLibrary_ = conv.byteArrayToString(data, 58, 10).trim();
            int numPools = BinaryConverter.byteArrayToInt(data, 76);
            this.pools_ = new SystemPool[10];
            int poolID = 0;
            for (i = 0; i < numPools; ++i) {
                int offsetToEntry = 80 + 28 * i;
                poolID = BinaryConverter.byteArrayToInt(data, offsetToEntry);
                String poolName = conv.byteArrayToString(data, offsetToEntry + 4, 10).trim();
                int size = BinaryConverter.byteArrayToInt(data, offsetToEntry + 20);
                int activityLevel = BinaryConverter.byteArrayToInt(data, offsetToEntry + 24);
                SystemPool pool = null;
                pool = poolName.equals("*USERPOOL") ? new SystemPool(this, poolID, size, activityLevel) : new SystemPool(this.system_, poolName);
                pool.setCaching(true);
                this.pools_[poolID - 1] = pool;
            }
            for (i = poolID; i < 10; ++i) {
                this.pools_[i] = null;
            }
            this.refreshed_ = true;
        }
        catch (PropertyVetoException pve) {
            Trace.log(2, pve);
        }
    }

    public void removePool(int sequenceNumber) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (sequenceNumber < 1 || sequenceNumber > 10) {
            throw new ExtendedIllegalArgumentException("sequenceNumber", 4);
        }
        CommandCall cmd = new CommandCall(this.system_, "QSYS/CHGSBSD SBSD(" + this.library_ + "/" + this.name_ + ") POOLS((" + sequenceNumber + " *RMV))");
        if (!cmd.run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                throw new AS400Exception(msgs);
            }
            Trace.log(2, NO_MESSAGES_RETURNED);
            throw new InternalErrorException(6);
        }
    }

    public void start() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        CommandCall cmd = new CommandCall(this.system_, "QSYS/STRSBS SBSD(" + this.library_ + "/" + this.name_ + ")");
        if (!cmd.run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                if (msgs[0].getID() != null && !msgs[0].getID().equals("CPF1010")) {
                    throw new AS400Exception(msgs);
                }
            } else {
                Trace.log(2, NO_MESSAGES_RETURNED);
                throw new InternalErrorException(6);
            }
        }
    }

    private static void end(AS400 system, String subsystemName, boolean immediate, int timeLimit) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException {
        CommandCall cmd;
        String endOption = immediate ? "*IMMED" : "*CNTRLD";
        StringBuilder cmdBuf = new StringBuilder("QSYS/ENDSBS SBS(" + subsystemName + ") OPTION(" + endOption + ")");
        if (!immediate) {
            cmdBuf.append(" DELAY(").append(timeLimit).append(")");
        }
        if (!(cmd = new CommandCall(system, cmdBuf.toString())).run()) {
            AS400Message[] msgs = cmd.getMessageList();
            if (msgs.length > 0) {
                if (!(msgs[0].getID() == null || msgs[0].getID().equals("CPF1032") || msgs[0].getID().equals("CPF1033") || msgs[0].getID().equals("CPF1034") || msgs[0].getID().equals("CPF1035") || msgs[0].getID().equals("CPF1036") || msgs[0].getID().equals("CPF1037") || msgs[0].getID().equals("CPF1054") || msgs[0].getID().equals("CPF1055") || msgs[0].getID().equals("CPF1056"))) {
                    throw new AS400Exception(msgs);
                }
            } else {
                Trace.log(2, NO_MESSAGES_RETURNED);
                throw new InternalErrorException(6);
            }
        }
    }

    private ObjectDescription getObjDesc() {
        return new ObjectDescription(this.system_, this.library_, this.name_, "SBSD");
    }
}

