/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.framework;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.testing.classic.ClassicTestClient;
import org.apache.hc.core5.testing.framework.ClientPOJOAdapter;
import org.apache.hc.core5.util.Timeout;

public class ClassicTestClientAdapter
extends ClientPOJOAdapter {
    @Override
    public Map<String, Object> execute(String defaultURI, Map<String, Object> request) throws Exception {
        String requestBody;
        Map headersMap;
        URI uri;
        if (defaultURI == null) {
            throw new HttpException("defaultURL cannot be null");
        }
        if (request == null) {
            throw new HttpException("request cannot be null");
        }
        if (!request.containsKey("path")) {
            throw new HttpException("Request path should be set.");
        }
        if (!request.containsKey("method")) {
            throw new HttpException("Request method should be set.");
        }
        Timeout timeout = request.containsKey("timeout") ? Timeout.ofMilliseconds((long)((Long)request.get("timeout"))) : null;
        ClassicTestClient client = new ClassicTestClient(SocketConfig.custom().setSoTimeout(timeout).build());
        String tempDefaultURI = defaultURI;
        if (!defaultURI.endsWith("/")) {
            tempDefaultURI = tempDefaultURI + "/";
        }
        URI startingURI = new URI(tempDefaultURI + request.get("path"));
        Map queryMap = (Map)request.get("query");
        if (queryMap != null) {
            String existingQuery = startingURI.getRawQuery();
            StringBuilder newQuery = new StringBuilder(existingQuery == null ? "" : existingQuery);
            for (Map.Entry parm : queryMap.entrySet()) {
                newQuery.append("&").append((String)parm.getKey()).append("=").append((String)parm.getValue());
            }
            uri = new URI(startingURI.getRawSchemeSpecificPart(), startingURI.getRawUserInfo(), startingURI.getHost(), startingURI.getPort(), startingURI.getRawPath(), newQuery.toString(), startingURI.getRawFragment());
        } else {
            uri = startingURI;
        }
        BasicClassicHttpRequest httpRequest = new BasicClassicHttpRequest(request.get("method").toString(), uri);
        if (request.containsKey("protocolVersion")) {
            httpRequest.setVersion((ProtocolVersion)request.get("protocolVersion"));
        }
        if ((headersMap = (Map)request.get("headers")) != null) {
            for (Map.Entry header : headersMap.entrySet()) {
                httpRequest.addHeader((String)header.getKey(), header.getValue());
            }
        }
        if ((requestBody = (String)request.get("body")) != null) {
            String requestContentType = (String)request.get("contentType");
            StringEntity entity = requestContentType != null ? new StringEntity(requestBody, ContentType.parse((CharSequence)requestContentType)) : new StringEntity(requestBody);
            httpRequest.setEntity((HttpEntity)entity);
        }
        client.start(null);
        HttpHost host = new HttpHost(uri.getHost(), uri.getPort());
        HttpCoreContext context = HttpCoreContext.create();
        try (ClassicHttpResponse response = client.execute(host, (ClassicHttpRequest)httpRequest, (HttpContext)context);){
            HttpEntity entity = response.getEntity();
            String body = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
            String contentType = entity == null ? null : entity.getContentType();
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("status", response.getCode());
            HashMap<String, String> headerMap = new HashMap<String, String>();
            for (Header header : response.getHeaders()) {
                headerMap.put(header.getName(), header.getValue());
            }
            ret.put("headers", headerMap);
            ret.put("body", body);
            ret.put("contentType", contentType);
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
    }

    @Override
    public String getClientName() {
        return "ClassicTestClient";
    }
}

