/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentLengthStrategy;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.LengthRequiredException;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NotImplementedException;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.impl.DefaultContentLengthStrategy;
import org.apache.hc.core5.http.impl.io.ChunkedInputStream;
import org.apache.hc.core5.http.impl.io.ContentLengthInputStream;
import org.apache.hc.core5.http.impl.io.DefaultBHttpClientConnection;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.hc.core5.http.impl.io.IdentityInputStream;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

class TestDefaultBHttpClientConnection {
    @Mock
    private Socket socket;
    private DefaultBHttpClientConnection conn;

    TestDefaultBHttpClientConnection() {
    }

    @BeforeEach
    void prepareMocks() {
        MockitoAnnotations.openMocks((Object)this);
        this.conn = new DefaultBHttpClientConnection(Http1Config.DEFAULT, null, null, (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE, (ContentLengthStrategy)DefaultContentLengthStrategy.INSTANCE, (HttpMessageWriterFactory)DefaultHttpRequestWriterFactory.INSTANCE, (HttpMessageParserFactory)DefaultHttpResponseParserFactory.INSTANCE);
    }

    @Test
    void testBasics() {
        Assertions.assertFalse((boolean)this.conn.isOpen());
        Assertions.assertEquals((Object)"[Not bound]", (Object)this.conn.toString());
    }

    @Test
    void testReadResponseHead() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nUser-Agent: test\r\n\r\n";
        ByteArrayInputStream inStream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nUser-Agent: test\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        ClassicHttpResponse response = this.conn.receiveResponseHeader();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.getCode());
        Assertions.assertTrue((boolean)response.containsHeader("User-Agent"));
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
    }

    @Test
    void testReadResponseEntityWithoutContentLength() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nServer: test\r\n\r\n123";
        ByteArrayInputStream inStream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nServer: test\r\n\r\n123".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        ClassicHttpResponse response = this.conn.receiveResponseHeader();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.getCode());
        Assertions.assertTrue((boolean)response.containsHeader("Server"));
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        this.conn.receiveResponseEntity(response);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((long)-1L, (long)entity.getContentLength());
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        InputStream content = entity.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertEquals((int)3, (int)content.available());
        Assertions.assertEquals((int)49, (int)content.read());
        Assertions.assertEquals((int)50, (int)content.read());
        Assertions.assertEquals((int)51, (int)content.read());
    }

    @Test
    void testReadResponseEntityWithContentLength() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nServer: test\r\nContent-Length: 3\r\n\r\n123";
        ByteArrayInputStream inStream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nServer: test\r\nContent-Length: 3\r\n\r\n123".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        ClassicHttpResponse response = this.conn.receiveResponseHeader();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.getCode());
        Assertions.assertTrue((boolean)response.containsHeader("Server"));
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        this.conn.receiveResponseEntity(response);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((long)3L, (long)entity.getContentLength());
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        InputStream content = entity.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertTrue((boolean)(content instanceof ContentLengthInputStream));
    }

    @Test
    void testReadResponseEntityChunkCoded() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nServer: test\r\nTransfer-Encoding: chunked\r\n\r\n3\r\n123\r\n0\r\n\r\n";
        ByteArrayInputStream inStream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nServer: test\r\nTransfer-Encoding: chunked\r\n\r\n3\r\n123\r\n0\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        ClassicHttpResponse response = this.conn.receiveResponseHeader();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.getCode());
        Assertions.assertTrue((boolean)response.containsHeader("Server"));
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        this.conn.receiveResponseEntity(response);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        Assertions.assertEquals((long)-1L, (long)entity.getContentLength());
        Assertions.assertTrue((boolean)entity.isChunked());
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        InputStream content = entity.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertTrue((boolean)(content instanceof ChunkedInputStream));
    }

    @Test
    void testReadResponseEntityIdentity() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nServer: test\r\nTransfer-Encoding: identity\r\n\r\n123";
        ByteArrayInputStream inStream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nServer: test\r\nTransfer-Encoding: identity\r\n\r\n123".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        ClassicHttpResponse response = this.conn.receiveResponseHeader();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.getCode());
        Assertions.assertTrue((boolean)response.containsHeader("Server"));
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        Assertions.assertThrows(NotImplementedException.class, () -> this.conn.receiveResponseEntity(response));
    }

    @Test
    void testReadResponseNoEntity() throws Exception {
        String s = "HTTP/1.1 200 OK\r\nServer: test\r\n\r\n";
        ByteArrayInputStream inStream = new ByteArrayInputStream("HTTP/1.1 200 OK\r\nServer: test\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        Mockito.when((Object)this.socket.getInputStream()).thenReturn((Object)inStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getResponseCount());
        ClassicHttpResponse response = this.conn.receiveResponseHeader();
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((int)200, (int)response.getCode());
        Assertions.assertTrue((boolean)response.containsHeader("Server"));
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getResponseCount());
        this.conn.receiveResponseEntity(response);
        HttpEntity entity = response.getEntity();
        Assertions.assertNotNull((Object)entity);
        InputStream content = entity.getContent();
        Assertions.assertNotNull((Object)content);
        Assertions.assertTrue((boolean)(content instanceof IdentityInputStream));
    }

    @Test
    void testWriteRequestHead() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/stuff");
        request.addHeader("User-Agent", (Object)"test");
        this.conn.sendRequestHeader((ClassicHttpRequest)request);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"GET /stuff HTTP/1.1\r\nUser-Agent: test\r\n\r\n", (Object)s);
    }

    @Test
    void testWriteRequestEntityWithContentLength() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/stuff");
        request.addHeader("User-Agent", (Object)"test");
        request.addHeader("Content-Length", (Object)"3");
        request.setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN));
        this.conn.sendRequestHeader((ClassicHttpRequest)request);
        this.conn.sendRequestEntity((ClassicHttpRequest)request);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123", (Object)s);
    }

    @Test
    void testWriteRequestEntityChunkCoded() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/stuff");
        request.addHeader("User-Agent", (Object)"test");
        request.addHeader("Transfer-Encoding", (Object)"chunked");
        request.setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN));
        this.conn.sendRequestHeader((ClassicHttpRequest)request);
        this.conn.sendRequestEntity((ClassicHttpRequest)request);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nTransfer-Encoding: chunked\r\n\r\n3\r\n123\r\n0\r\n\r\n", (Object)s);
    }

    @Test
    void testWriteRequestEntityNoContentLength() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/stuff");
        request.addHeader("User-Agent", (Object)"test");
        request.setEntity((HttpEntity)new StringEntity("123", ContentType.TEXT_PLAIN));
        this.conn.sendRequestHeader((ClassicHttpRequest)request);
        Assertions.assertThrows(LengthRequiredException.class, () -> this.lambda$testWriteRequestEntityNoContentLength$1((ClassicHttpRequest)request));
    }

    @Test
    void testWriteRequestNoEntity() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/stuff");
        request.addHeader("User-Agent", (Object)"test");
        this.conn.sendRequestHeader((ClassicHttpRequest)request);
        this.conn.sendRequestEntity((ClassicHttpRequest)request);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"POST /stuff HTTP/1.1\r\nUser-Agent: test\r\n\r\n", (Object)s);
    }

    @Test
    void testTerminateRequestChunkedEntity() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/stuff");
        request.addHeader("User-Agent", (Object)"test");
        request.addHeader("Transfer-Encoding", (Object)"chunked");
        StringEntity entity = new StringEntity("123", ContentType.TEXT_PLAIN, true);
        request.setEntity((HttpEntity)entity);
        this.conn.sendRequestHeader((ClassicHttpRequest)request);
        this.conn.terminateRequest((ClassicHttpRequest)request);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n", (Object)s);
        Assertions.assertTrue((boolean)this.conn.isConsistent());
    }

    @Test
    void testTerminateRequestContentLengthShort() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/stuff");
        request.addHeader("User-Agent", (Object)"test");
        request.addHeader("Content-Length", (Object)"3");
        StringEntity entity = new StringEntity("123", ContentType.TEXT_PLAIN, true);
        request.setEntity((HttpEntity)entity);
        this.conn.sendRequestHeader((ClassicHttpRequest)request);
        this.conn.terminateRequest((ClassicHttpRequest)request);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nContent-Length: 3\r\n\r\n123", (Object)s);
        Assertions.assertTrue((boolean)this.conn.isConsistent());
    }

    @Test
    void testTerminateRequestContentLengthLong() throws Exception {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Mockito.when((Object)this.socket.getOutputStream()).thenReturn((Object)outStream);
        this.conn.bind(this.socket);
        Assertions.assertEquals((long)0L, (long)this.conn.getEndpointDetails().getRequestCount());
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/stuff");
        request.addHeader("User-Agent", (Object)"test");
        request.addHeader("Content-Length", (Object)"3000");
        ByteArrayEntity entity = new ByteArrayEntity(new byte[3000], ContentType.TEXT_PLAIN, true);
        request.setEntity((HttpEntity)entity);
        this.conn.sendRequestHeader((ClassicHttpRequest)request);
        this.conn.terminateRequest((ClassicHttpRequest)request);
        this.conn.flush();
        Assertions.assertEquals((long)1L, (long)this.conn.getEndpointDetails().getRequestCount());
        String s = new String(outStream.toByteArray(), StandardCharsets.US_ASCII);
        Assertions.assertEquals((Object)"POST /stuff HTTP/1.1\r\nUser-Agent: test\r\nContent-Length: 3000\r\n\r\n", (Object)s);
        Assertions.assertFalse((boolean)this.conn.isConsistent());
    }

    private /* synthetic */ void lambda$testWriteRequestEntityNoContentLength$1(ClassicHttpRequest request) throws Throwable {
        this.conn.sendRequestEntity(request);
    }
}

