/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.client.proto;

/**
 * Client error codes.
 */
public class ClientErrorCode {
    /** Operation succeeded (no error). */
    public static final int SUCCESS = 0;

    /** General error (uncategorized). */
    public static final int FAILED = 1;

    /** Authentication or authorization failure. */
    public static final int AUTH_FAILED = 2;

    /** Table id does not exist. */
    public static final int TABLE_ID_DOES_NOT_EXIST = 3;
}
