/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaMethodElement;
import io.micronaut.annotation.processing.visitor.JavaPropertyElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.visitor.VisitorContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;

@Internal
public class JavaClassElementExt {
    private final TypeElement typeElement;
    private final JavaClassElement classElement;
    private final JavaVisitorContext visitorContext;

    public JavaClassElementExt(ClassElement javaClassElement, VisitorContext javaVisitorContext) {
        this.classElement = (JavaClassElement)javaClassElement;
        this.visitorContext = (JavaVisitorContext)javaVisitorContext;
        this.typeElement = (TypeElement)javaClassElement.getNativeType();
    }

    public List<PropertyElement> fluentBeanProperties() {
        LinkedHashMap<String, BeanPropertyData> props = new LinkedHashMap<String, BeanPropertyData>();
        LinkedHashMap<String, VariableElement> fields = new LinkedHashMap<String, VariableElement>();
        Elements elements = this.visitorContext.getElements();
        ElementFilter.fieldsIn(elements.getAllMembers(this.typeElement)).forEach(v -> fields.put(v.getSimpleName().toString(), (VariableElement)v));
        Set fieldNames = fields.keySet();
        ElementFilter.methodsIn(elements.getAllMembers(this.typeElement)).stream().filter(method -> !JavaClassElementExt.isObjectClassMethod(method, elements)).filter(method -> this.isCandidateFluentBeanMethod((ExecutableElement)method, fieldNames)).forEach(executableElement -> this.fluentBeanProperty((Map<String, BeanPropertyData>)props, (ExecutableElement)executableElement));
        return this.processPropertyElements(props, fields);
    }

    private static boolean isObjectClassMethod(ExecutableElement method, Elements elements) {
        TypeElement te = (TypeElement)method.getEnclosingElement();
        return te.equals(elements.getTypeElement("java.lang.Object"));
    }

    private boolean isCandidateFluentBeanMethod(ExecutableElement method, Set<String> fieldNames) {
        if (!this.checkModifiers(method)) {
            return false;
        }
        String methodName = method.getSimpleName().toString();
        return fieldNames.contains(methodName) && (method.getParameters().isEmpty() || method.getParameters().size() == 1);
    }

    private boolean checkModifiers(ExecutableElement method) {
        Set<Modifier> modifiers = method.getModifiers();
        return method.getModifiers().contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.STATIC) && !modifiers.contains((Object)Modifier.PRIVATE) && !method.getSimpleName().toString().contains("$");
    }

    private void fluentBeanProperty(Map<String, BeanPropertyData> props, ExecutableElement executableElement) {
        String methodName = executableElement.getSimpleName().toString();
        TypeElement declaringTypeElement = (TypeElement)executableElement.getEnclosingElement();
        if (executableElement.getParameters().isEmpty()) {
            this.getterBeanProperty(props, executableElement, methodName, declaringTypeElement);
        } else if (executableElement.getParameters().size() == 1) {
            this.setterBeanProperty(props, executableElement, methodName, declaringTypeElement);
        }
    }

    private void getterBeanProperty(Map<String, BeanPropertyData> props, ExecutableElement executableElement, String methodName, TypeElement declaringTypeElement) {
        TypeMirror typeMirror;
        ClassElement setterParameterType;
        Object getterReturnType;
        String propertyName = NameUtils.getPropertyNameForGetter((String)methodName);
        TypeMirror returnType = executableElement.getReturnType();
        if (returnType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)returnType;
            String tvn = tv.toString();
            ClassElement ce = (ClassElement)this.classElement.getTypeArguments().get(tvn);
            getterReturnType = ce != null ? this.classElement : this.classElement.mirrorToClassElement(returnType, this.visitorContext, this.classElement.getGenericTypeInfo(), true);
        } else {
            getterReturnType = this.classElement.mirrorToClassElement(returnType, this.visitorContext, this.classElement.getGenericTypeInfo(), true);
        }
        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
        this.configureDeclaringType(declaringTypeElement, beanPropertyData);
        beanPropertyData.type = getterReturnType;
        beanPropertyData.getter = executableElement;
        if (beanPropertyData.setter != null && !(setterParameterType = this.classElement.mirrorToClassElement(typeMirror = beanPropertyData.setter.getParameters().get(0).asType(), this.visitorContext, this.classElement.getGenericTypeInfo(), true)).getName().equals(getterReturnType.getName())) {
            beanPropertyData.setter = null;
        }
    }

    private void setterBeanProperty(Map<String, BeanPropertyData> props, ExecutableElement executableElement, String methodName, TypeElement declaringTypeElement) {
        String propertyName = NameUtils.getPropertyNameForSetter((String)methodName);
        TypeMirror typeMirror = executableElement.getParameters().get(0).asType();
        ClassElement setterParameterType = this.classElement.mirrorToClassElement(typeMirror, this.visitorContext, this.classElement.getGenericTypeInfo(), true);
        BeanPropertyData beanPropertyData = props.computeIfAbsent(propertyName, BeanPropertyData::new);
        this.configureDeclaringType(declaringTypeElement, beanPropertyData);
        ClassElement propertyType = beanPropertyData.type;
        if (propertyType != null) {
            if (propertyType.getName().equals(setterParameterType.getName())) {
                beanPropertyData.setter = executableElement;
            }
        } else {
            beanPropertyData.setter = executableElement;
        }
    }

    private void configureDeclaringType(TypeElement declaringTypeElement, BeanPropertyData beanPropertyData) {
        if (beanPropertyData.declaringType == null && !this.classElement.equals((Object)declaringTypeElement)) {
            beanPropertyData.declaringType = this.classElement.mirrorToClassElement(declaringTypeElement.asType(), this.visitorContext, this.classElement.getGenericTypeInfo(), true);
        } else if (beanPropertyData.declaringType == null) {
            beanPropertyData.declaringType = this.classElement.mirrorToClassElement(declaringTypeElement.asType(), this.visitorContext, this.classElement.getGenericTypeInfo(), false);
        }
    }

    private List<PropertyElement> processPropertyElements(Map<String, BeanPropertyData> props, Map<String, VariableElement> fields) {
        if (props.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<JavaPropertyElement> propertyElements = new ArrayList<JavaPropertyElement>();
        for (Map.Entry<String, BeanPropertyData> entry : props.entrySet()) {
            String propertyName = entry.getKey();
            BeanPropertyData value = entry.getValue();
            VariableElement fieldElement = fields.get(propertyName);
            if (value.getter == null) continue;
            AnnotationMetadata annotationMetadata = fieldElement != null ? this.visitorContext.getAnnotationUtils().getAnnotationMetadata((Element)fieldElement, (Element)value.getter) : this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod((Object)value.getter);
            propertyElements.add(this.toPropertyElement(propertyName, value, annotationMetadata));
        }
        return Collections.unmodifiableList(propertyElements);
    }

    private JavaPropertyElement toPropertyElement(String propertyName, final BeanPropertyData value, final AnnotationMetadata annotationMetadata) {
        return new JavaPropertyElement((ClassElement)(value.declaringType == null ? this.classElement : value.declaringType), value.getter, annotationMetadata, propertyName, value.type, value.setter == null, this.visitorContext){

            public Optional<String> getDocumentation() {
                Elements elements = JavaClassElementExt.this.visitorContext.getElements();
                String docComment = elements.getDocComment(value.getter);
                return Optional.ofNullable(docComment);
            }

            public Optional<MethodElement> getWriteMethod() {
                if (value.setter != null) {
                    return Optional.of(new JavaMethodElement(JavaClassElementExt.this.classElement, value.setter, JavaClassElementExt.this.visitorContext.getAnnotationUtils().newAnnotationBuilder().buildForMethod((Object)value.setter), JavaClassElementExt.this.visitorContext));
                }
                return Optional.empty();
            }

            public Optional<MethodElement> getReadMethod() {
                return Optional.of(new JavaMethodElement(JavaClassElementExt.this.classElement, value.getter, annotationMetadata, JavaClassElementExt.this.visitorContext));
            }
        };
    }

    private static class BeanPropertyData {
        ClassElement type;
        ClassElement declaringType;
        ExecutableElement getter;
        ExecutableElement setter;
        final String propertyName;

        BeanPropertyData(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

