/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagememory.persistence.checkpoint;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BooleanSupplier;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.pagememory.FullPageId;
import org.apache.ignite.internal.pagememory.configuration.schema.PageMemoryCheckpointConfiguration;
import org.apache.ignite.internal.pagememory.configuration.schema.PageMemoryCheckpointView;
import org.apache.ignite.internal.pagememory.persistence.GroupPartitionId;
import org.apache.ignite.internal.pagememory.persistence.PersistentPageMemory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.Checkpoint;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointDirtyPages;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointMetricsTracker;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointPagesWriter;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointPagesWriterFactory;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointProgressImpl;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointState;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointWorkflow;
import org.apache.ignite.internal.pagememory.persistence.compaction.Compactor;
import org.apache.ignite.internal.pagememory.persistence.store.DeltaFilePageStoreIo;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStore;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.thread.IgniteThread;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.IgniteConcurrentMultiPairQueue;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.worker.IgniteWorker;
import org.apache.ignite.internal.util.worker.IgniteWorkerListener;
import org.apache.ignite.internal.util.worker.WorkProgressDispatcher;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.lang.IgniteInternalException;
import org.apache.ignite.lang.NodeStoppingException;
import org.jetbrains.annotations.Nullable;

public class Checkpointer
extends IgniteWorker {
    private static final String CHECKPOINT_STARTED_LOG_FORMAT = "Checkpoint started [checkpointId=%s, checkpointBeforeWriteLockTime=%dms, checkpointWriteLockWait=%dms, checkpointListenersExecuteTime=%dms, checkpointWriteLockHoldTime=%dms, splitAndSortPagesDuration=%dms, %spages=%d, reason='%s']";
    @Nullable
    private final LongJvmPauseDetector pauseDetector;
    private final PageMemoryCheckpointConfiguration checkpointConfig;
    private final CheckpointWorkflow checkpointWorkflow;
    private final CheckpointPagesWriterFactory checkpointPagesWriterFactory;
    @Nullable
    private final ThreadPoolExecutor checkpointWritePagesPool;
    private volatile CheckpointProgressImpl scheduledCheckpointProgress;
    @Nullable
    private volatile CheckpointProgressImpl currentCheckpointProgress;
    @Nullable
    private volatile CheckpointProgressImpl afterReleaseWriteLockCheckpointProgress;
    private volatile boolean shutdownNow;
    private long lastCheckpointTimestamp;
    private final FilePageStoreManager filePageStoreManager;
    private final Compactor compactor;

    Checkpointer(IgniteLogger log, String igniteInstanceName, @Nullable IgniteWorkerListener workerListener, @Nullable LongJvmPauseDetector detector, CheckpointWorkflow checkpointWorkFlow, CheckpointPagesWriterFactory factory, FilePageStoreManager filePageStoreManager, Compactor compactor, PageMemoryCheckpointConfiguration checkpointConfig) {
        super(log, igniteInstanceName, "checkpoint-thread", workerListener);
        this.pauseDetector = detector;
        this.checkpointConfig = checkpointConfig;
        this.checkpointWorkflow = checkpointWorkFlow;
        this.checkpointPagesWriterFactory = factory;
        this.filePageStoreManager = filePageStoreManager;
        this.compactor = compactor;
        this.scheduledCheckpointProgress = new CheckpointProgressImpl(TimeUnit.MILLISECONDS.toNanos(this.nextCheckpointInterval()));
        int checkpointWritePageThreads = (Integer)checkpointConfig.checkpointThreads().value();
        this.checkpointWritePagesPool = checkpointWritePageThreads > 1 ? new ThreadPoolExecutor(checkpointWritePageThreads, checkpointWritePageThreads, 30000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("checkpoint-runner-io", log)) : null;
    }

    protected void body() {
        try {
            while (!this.isCancelled()) {
                this.waitCheckpointEvent();
                if (this.isCancelled() || this.shutdownNow) {
                    this.log.info("Skipping last checkpoint because node is stopping", new Object[0]);
                    return;
                }
                this.doCheckpoint();
            }
            if (!this.shutdownNow) {
                this.doCheckpoint();
            }
            if (!this.isCancelled.get()) {
                throw new IllegalStateException("Thread is terminated unexpectedly: " + this.name());
            }
            this.scheduledCheckpointProgress.fail((Throwable)new NodeStoppingException("Node is stopping."));
        }
        catch (Throwable t) {
            this.scheduledCheckpointProgress.fail(t);
            throw new IgniteInternalException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckpointProgress scheduleCheckpoint(long delayFromNow, String reason) {
        CheckpointProgressImpl current = this.currentCheckpointProgress;
        if (current != null && !current.greaterOrEqualTo(CheckpointState.LOCK_TAKEN)) {
            return current;
        }
        current = this.scheduledCheckpointProgress;
        long nextNanos = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(delayFromNow);
        if (current.nextCheckpointNanos() - nextNanos <= 0L) {
            return current;
        }
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            current = this.scheduledCheckpointProgress;
            if (current.nextCheckpointNanos() - nextNanos > 0L) {
                current.reason(reason);
                current.nextCheckpointNanos(TimeUnit.MILLISECONDS.toNanos(delayFromNow));
            }
            ((Object)((Object)this)).notifyAll();
        }
        return current;
    }

    void doCheckpoint() throws IgniteInternalCheckedException {
        Checkpoint chp = null;
        try {
            CheckpointMetricsTracker tracker = new CheckpointMetricsTracker();
            this.startCheckpointProgress();
            try {
                chp = this.checkpointWorkflow.markCheckpointBegin(this.lastCheckpointTimestamp, this.currentCheckpointProgress, tracker, () -> ((Checkpointer)this).updateHeartbeat(), this::updateLastProgressAfterReleaseWriteLock);
            }
            catch (Exception e) {
                if (this.currentCheckpointProgress != null) {
                    this.currentCheckpointProgress.fail(e);
                }
                throw new IgniteInternalCheckedException((Throwable)e);
            }
            this.updateHeartbeat();
            if (chp.hasDelta()) {
                if (this.log.isInfoEnabled()) {
                    long possibleJvmPauseDuration = this.possibleLongJvmPauseDuration(tracker);
                    if (this.log.isInfoEnabled()) {
                        this.log.info(String.format(CHECKPOINT_STARTED_LOG_FORMAT, chp.progress.id(), tracker.beforeWriteLockDuration(), tracker.writeLockWaitDuration(), tracker.onMarkCheckpointBeginDuration(), tracker.writeLockHoldDuration(), tracker.splitAndSortCheckpointPagesDuration(), possibleJvmPauseDuration > 0L ? "possibleJvmPauseDuration=" + possibleJvmPauseDuration + "ms, " : "", chp.dirtyPagesSize, chp.progress.reason()), new Object[0]);
                    }
                }
                if (!this.writePages(tracker, chp.dirtyPages, chp.progress, (WorkProgressDispatcher)this, this::isShutdownNow)) {
                    return;
                }
            } else {
                if (this.log.isInfoEnabled()) {
                    this.log.info(String.format("Skipping checkpoint (no pages were modified) [checkpointBeforeWriteLockTime=%dms, checkpointWriteLockWait=%dms, checkpointListenersExecuteTime=%dms, checkpointWriteLockHoldTime=%dms, reason='%s']", tracker.beforeWriteLockDuration(), tracker.writeLockWaitDuration(), tracker.onMarkCheckpointBeginDuration(), tracker.writeLockHoldDuration(), chp.progress.reason()), new Object[0]);
                }
                tracker.onPagesWriteStart();
                tracker.onFsyncStart();
            }
            this.checkpointWorkflow.markCheckpointEnd(chp);
            tracker.onCheckpointEnd();
            if (chp.hasDelta() && this.log.isInfoEnabled()) {
                this.log.info(String.format("Checkpoint finished [checkpointId=%s, pages=%d, pagesWriteTime=%dms, fsyncTime=%dms, totalTime=%dms]", chp.progress.id(), chp.dirtyPagesSize, tracker.pagesWriteDuration(), tracker.fsyncDuration(), tracker.totalDuration()), new Object[0]);
            }
        }
        catch (IgniteInternalCheckedException e) {
            if (chp != null) {
                chp.progress.fail(e);
            }
            throw e;
        }
    }

    boolean writePages(CheckpointMetricsTracker tracker, CheckpointDirtyPages checkpointDirtyPages, CheckpointProgressImpl currentCheckpointProgress, WorkProgressDispatcher workProgressDispatcher, BooleanSupplier shutdownNow) throws IgniteInternalCheckedException {
        ThreadPoolExecutor pageWritePool = this.checkpointWritePagesPool;
        int checkpointWritePageThreads = pageWritePool == null ? 1 : pageWritePool.getMaximumPoolSize();
        ConcurrentHashMap<GroupPartitionId, LongAdder> updatedPartitions = new ConcurrentHashMap<GroupPartitionId, LongAdder>();
        CompletableFuture[] futures = new CompletableFuture[checkpointWritePageThreads];
        tracker.onPagesWriteStart();
        IgniteConcurrentMultiPairQueue<PersistentPageMemory, FullPageId> writePageIds = checkpointDirtyPages.toDirtyPageIdQueue();
        for (int i = 0; i < checkpointWritePageThreads; ++i) {
            futures[i] = new CompletableFuture();
            CheckpointPagesWriter write = this.checkpointPagesWriterFactory.build(tracker, writePageIds, updatedPartitions, futures[i], () -> ((WorkProgressDispatcher)workProgressDispatcher).updateHeartbeat(), currentCheckpointProgress, shutdownNow);
            if (pageWritePool == null) {
                write.run();
                continue;
            }
            pageWritePool.execute(write);
        }
        workProgressDispatcher.updateHeartbeat();
        CompletableFuture.allOf(futures).join();
        if (shutdownNow.getAsBoolean()) {
            currentCheckpointProgress.fail((Throwable)new NodeStoppingException("Node is stopping."));
            return false;
        }
        tracker.onFsyncStart();
        this.syncUpdatedPageStores(updatedPartitions);
        this.compactor.addDeltaFiles(updatedPartitions.size());
        if (shutdownNow.getAsBoolean()) {
            currentCheckpointProgress.fail((Throwable)new NodeStoppingException("Node is stopping."));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncUpdatedPageStores(ConcurrentMap<GroupPartitionId, LongAdder> updatedPartitions) throws IgniteInternalCheckedException {
        ThreadPoolExecutor pageWritePool = this.checkpointWritePagesPool;
        if (pageWritePool == null) {
            for (Map.Entry entry : updatedPartitions.entrySet()) {
                if (this.shutdownNow) {
                    return;
                }
                this.fsyncDeltaFilePageStoreOnCheckpointThread((GroupPartitionId)entry.getKey(), (LongAdder)entry.getValue());
                this.renameDeltaFileOnCheckpointThread((GroupPartitionId)entry.getKey());
            }
        } else {
            int checkpointThreads = pageWritePool.getMaximumPoolSize();
            CompletableFuture[] futures = new CompletableFuture[checkpointThreads];
            for (int i = 0; i < checkpointThreads; ++i) {
                futures[i] = new CompletableFuture();
            }
            LinkedBlockingQueue queue = new LinkedBlockingQueue(updatedPartitions.entrySet());
            int i = 0;
            while (i < checkpointThreads) {
                int threadIdx = i++;
                pageWritePool.execute(() -> {
                    Map.Entry entry = (Map.Entry)queue.poll();
                    try {
                        while (entry != null) {
                            if (this.shutdownNow) {
                                return;
                            }
                            this.fsyncDeltaFilePageStoreOnCheckpointThread((GroupPartitionId)entry.getKey(), (LongAdder)entry.getValue());
                            this.renameDeltaFileOnCheckpointThread((GroupPartitionId)entry.getKey());
                            entry = (Map.Entry)queue.poll();
                        }
                        futures[threadIdx].complete(null);
                    }
                    catch (Throwable t) {
                        futures[threadIdx].completeExceptionally(t);
                    }
                });
            }
            this.blockingSectionBegin();
            try {
                CompletableFuture.allOf(futures).join();
            }
            finally {
                this.blockingSectionEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitCheckpointEvent() {
        try {
            Checkpointer checkpointer = this;
            synchronized (checkpointer) {
                long remaining = TimeUnit.NANOSECONDS.toMillis(this.scheduledCheckpointProgress.nextCheckpointNanos() - System.nanoTime());
                while (remaining > 0L && !this.isCancelled()) {
                    this.blockingSectionBegin();
                    try {
                        ((Object)((Object)this)).wait(remaining);
                        remaining = TimeUnit.NANOSECONDS.toMillis(this.scheduledCheckpointProgress.nextCheckpointNanos() - System.nanoTime());
                    }
                    finally {
                        this.blockingSectionEnd();
                    }
                }
            }
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
            this.isCancelled.set(true);
        }
    }

    private long possibleLongJvmPauseDuration(CheckpointMetricsTracker tracker) {
        if (this.pauseDetector != null && tracker.writeLockWaitDuration() + tracker.writeLockHoldDuration() > this.pauseDetector.longJvmPauseThreshold()) {
            long now = FastTimestamps.coarseCurrentTimeMillis();
            long wakeUpTime = this.pauseDetector.getLastWakeUpTime();
            IgniteBiTuple lastLongPause = this.pauseDetector.getLastLongPause();
            if (lastLongPause != null && tracker.checkpointStartTime() < (Long)lastLongPause.get1()) {
                return (Long)lastLongPause.get2();
            }
            if (now - wakeUpTime > this.pauseDetector.longJvmPauseThreshold()) {
                return now - wakeUpTime;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCheckpointProgress() {
        long checkpointStartTimestamp = FastTimestamps.coarseCurrentTimeMillis();
        if (checkpointStartTimestamp == this.lastCheckpointTimestamp) {
            ++checkpointStartTimestamp;
        }
        this.lastCheckpointTimestamp = checkpointStartTimestamp;
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            CheckpointProgressImpl curr = this.scheduledCheckpointProgress;
            if (curr.reason() == null) {
                curr.reason("timeout");
            }
            this.scheduledCheckpointProgress = new CheckpointProgressImpl(TimeUnit.MILLISECONDS.toNanos(this.nextCheckpointInterval()));
            this.currentCheckpointProgress = curr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cancelling grid runnable: " + this, new Object[0]);
        }
        this.isCancelled.set(true);
        Checkpointer checkpointer = this;
        synchronized (checkpointer) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public void shutdownNow() {
        this.shutdownNow = true;
        if (!this.isCancelled.get()) {
            this.cancel();
        }
    }

    public void start() {
        if (this.runner() != null) {
            return;
        }
        assert (this.runner() == null) : "Checkpointer is running.";
        new IgniteThread((IgniteWorker)this).start();
    }

    public void stop() throws Exception {
        this.shutdownCheckpointer(true);
    }

    public void shutdownCheckpointer(boolean shutdown) {
        if (shutdown) {
            this.shutdownNow();
        } else {
            this.cancel();
        }
        try {
            this.join();
        }
        catch (InterruptedException ignore) {
            this.log.info("Was interrupted while waiting for checkpointer shutdown, will not wait for checkpoint to finish", new Object[0]);
            Thread.currentThread().interrupt();
            this.shutdownNow();
            while (true) {
                try {
                    this.join();
                    this.scheduledCheckpointProgress.fail((Throwable)new NodeStoppingException("Checkpointer is stopped during node stop."));
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                break;
            }
            Thread.currentThread().interrupt();
        }
        if (this.checkpointWritePagesPool != null) {
            IgniteUtils.shutdownAndAwaitTermination((ExecutorService)this.checkpointWritePagesPool, (long)2L, (TimeUnit)TimeUnit.MINUTES);
        }
    }

    @Nullable
    public CheckpointProgress lastCheckpointProgress() {
        return this.afterReleaseWriteLockCheckpointProgress;
    }

    CheckpointProgress scheduledProgress() {
        return this.scheduledCheckpointProgress;
    }

    boolean isShutdownNow() {
        return this.shutdownNow;
    }

    long nextCheckpointInterval() {
        PageMemoryCheckpointView checkpointConfigView = (PageMemoryCheckpointView)this.checkpointConfig.value();
        long frequency = checkpointConfigView.frequency();
        int deviation = checkpointConfigView.frequencyDeviation();
        if (deviation == 0) {
            return frequency;
        }
        long deviationMills = frequency * (long)deviation;
        long startDelay = ThreadLocalRandom.current().nextLong(Math.max(IgniteUtils.safeAbs((long)deviationMills) / 100L, 1L)) - Math.max(IgniteUtils.safeAbs((long)deviationMills) / 200L, 1L);
        return IgniteUtils.safeAbs((long)(frequency + startDelay));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fsyncDeltaFilePageStoreOnCheckpointThread(GroupPartitionId partitionId, LongAdder pagesWritten) throws IgniteInternalCheckedException {
        this.blockingSectionBegin();
        try {
            FilePageStore filePageStore = this.filePageStoreManager.getStore(partitionId.getGroupId(), partitionId.getPartitionId());
            CompletableFuture<DeltaFilePageStoreIo> deltaFilePageStoreFuture = filePageStore.getNewDeltaFile();
            assert (deltaFilePageStoreFuture != null);
            deltaFilePageStoreFuture.join().sync();
        }
        finally {
            this.blockingSectionEnd();
        }
        this.currentCheckpointProgress.syncedPagesCounter().addAndGet(pagesWritten.intValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renameDeltaFileOnCheckpointThread(GroupPartitionId partitionId) throws IgniteInternalCheckedException {
        this.blockingSectionBegin();
        try {
            FilePageStore filePageStore = this.filePageStoreManager.getStore(partitionId.getGroupId(), partitionId.getPartitionId());
            CompletableFuture<DeltaFilePageStoreIo> deltaFilePageStoreFuture = filePageStore.getNewDeltaFile();
            assert (deltaFilePageStoreFuture != null);
            DeltaFilePageStoreIo deltaFilePageStoreIo = deltaFilePageStoreFuture.join();
            Path newDeltaFilePath = this.filePageStoreManager.deltaFilePageStorePath(partitionId.getGroupId(), partitionId.getPartitionId(), deltaFilePageStoreIo.fileIndex());
            try {
                deltaFilePageStoreIo.renameFilePath(newDeltaFilePath);
            }
            catch (IOException e) {
                throw new IgniteInternalCheckedException("Error when renaming delta file: " + deltaFilePageStoreIo.filePath(), (Throwable)e);
            }
            filePageStore.completeNewDeltaFile();
        }
        finally {
            this.blockingSectionEnd();
        }
    }

    void updateLastProgressAfterReleaseWriteLock() {
        this.afterReleaseWriteLockCheckpointProgress = this.currentCheckpointProgress;
    }
}

