/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.BitSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.client.handler.ClientContext;
import org.apache.ignite.client.handler.ClientResourceRegistry;
import org.apache.ignite.client.handler.JdbcQueryCursorHandlerImpl;
import org.apache.ignite.client.handler.JdbcQueryEventHandlerImpl;
import org.apache.ignite.client.handler.configuration.ClientConnectorView;
import org.apache.ignite.client.handler.requests.cluster.ClientClusterGetNodesRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeExecuteColocatedRequest;
import org.apache.ignite.client.handler.requests.compute.ClientComputeExecuteRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcCloseRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcColumnMetadataRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcExecuteBatchRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcExecuteRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcFetchRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcPreparedStmntBatchRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcPrimaryKeyMetadataRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcQueryMetadataRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcSchemasMetadataRequest;
import org.apache.ignite.client.handler.requests.jdbc.ClientJdbcTableMetadataRequest;
import org.apache.ignite.client.handler.requests.jdbc.JdbcMetadataCatalog;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCursorCloseRequest;
import org.apache.ignite.client.handler.requests.sql.ClientSqlCursorNextPageRequest;
import org.apache.ignite.client.handler.requests.sql.ClientSqlExecuteRequest;
import org.apache.ignite.client.handler.requests.table.ClientSchemasGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientTableGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientTablePartitionAssignmentGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientTablesGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleContainsKeyRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleDeleteAllExactRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleDeleteAllRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleDeleteExactRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleDeleteRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetAllRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetAndDeleteRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetAndReplaceRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetAndUpsertRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleGetRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleInsertAllRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleInsertRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleReplaceExactRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleReplaceRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleUpsertAllRequest;
import org.apache.ignite.client.handler.requests.table.ClientTupleUpsertRequest;
import org.apache.ignite.client.handler.requests.tx.ClientTransactionBeginRequest;
import org.apache.ignite.client.handler.requests.tx.ClientTransactionCommitRequest;
import org.apache.ignite.client.handler.requests.tx.ClientTransactionRollbackRequest;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.client.proto.ClientMessageCommon;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.client.proto.ProtocolVersion;
import org.apache.ignite.internal.client.proto.ResponseFlags;
import org.apache.ignite.internal.jdbc.proto.JdbcQueryCursorHandler;
import org.apache.ignite.internal.jdbc.proto.JdbcQueryEventHandler;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.sql.engine.QueryProcessor;
import org.apache.ignite.internal.table.IgniteTablesInternal;
import org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.ClusterService;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.manager.IgniteTables;
import org.apache.ignite.tx.IgniteTransactions;

public class ClientInboundMessageHandler
extends ChannelInboundHandlerAdapter {
    private static final IgniteLogger LOG = Loggers.forClass(ClientInboundMessageHandler.class);
    private final IgniteTablesInternal igniteTables;
    private final IgniteTransactions igniteTransactions;
    private final JdbcQueryEventHandler jdbcQueryEventHandler;
    private final ClientResourceRegistry resources = new ClientResourceRegistry();
    private final ClientConnectorView configuration;
    private final IgniteCompute compute;
    private final ClusterService clusterService;
    private final IgniteSql sql;
    private final JdbcQueryCursorHandler jdbcQueryCursorHandler;
    private ClientContext clientContext;
    private final AtomicBoolean partitionAssignmentChanged = new AtomicBoolean();

    public ClientInboundMessageHandler(IgniteTablesInternal igniteTables, IgniteTransactions igniteTransactions, QueryProcessor processor, ClientConnectorView configuration, IgniteCompute compute, ClusterService clusterService, IgniteSql sql) {
        assert (igniteTables != null);
        assert (igniteTransactions != null);
        assert (processor != null);
        assert (configuration != null);
        assert (compute != null);
        assert (clusterService != null);
        assert (sql != null);
        this.igniteTables = igniteTables;
        this.igniteTransactions = igniteTransactions;
        this.configuration = configuration;
        this.compute = compute;
        this.clusterService = clusterService;
        this.sql = sql;
        this.jdbcQueryEventHandler = new JdbcQueryEventHandlerImpl(processor, new JdbcMetadataCatalog((IgniteTables)igniteTables), this.resources);
        this.jdbcQueryCursorHandler = new JdbcQueryCursorHandlerImpl(this.resources);
        igniteTables.addAssignmentsChangeListener(this::onPartitionAssignmentChanged);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        try (ClientMessageUnpacker unpacker = this.getUnpacker((ByteBuf)msg);){
            ClientMessagePacker packer = this.getPacker(ctx.alloc());
            if (this.clientContext == null) {
                this.handshake(ctx, unpacker, packer);
            } else {
                this.processOperation(ctx, unpacker, packer);
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.resources.close();
        this.igniteTables.removeAssignmentsChangeListener(this::onPartitionAssignmentChanged);
        super.channelInactive(ctx);
    }

    private void handshake(ChannelHandlerContext ctx, ClientMessageUnpacker unpacker, ClientMessagePacker packer) {
        try {
            this.writeMagic(ctx);
            ProtocolVersion clientVer = ProtocolVersion.unpack((ClientMessageUnpacker)unpacker);
            if (!clientVer.equals((Object)ProtocolVersion.LATEST_VER)) {
                throw new IgniteException(ErrorGroups.Client.PROTOCOL_COMPATIBILITY_ERR, "Unsupported version: " + clientVer.major() + "." + clientVer.minor() + "." + clientVer.patch());
            }
            int clientCode = unpacker.unpackInt();
            int featuresLen = unpacker.unpackBinaryHeader();
            BitSet features = BitSet.valueOf(unpacker.readPayload(featuresLen));
            this.clientContext = new ClientContext(clientVer, clientCode, features);
            LOG.debug("Handshake: " + this.clientContext, new Object[0]);
            int extensionsLen = unpacker.unpackMapHeader();
            unpacker.skipValues(extensionsLen);
            ProtocolVersion.LATEST_VER.pack(packer);
            packer.packNil();
            packer.packLong(this.configuration.idleTimeout());
            ClusterNode localMember = this.clusterService.topologyService().localMember();
            packer.packString(localMember.id());
            packer.packString(localMember.name());
            packer.packBinaryHeader(0);
            packer.packMapHeader(0);
            this.write(packer, ctx);
        }
        catch (Throwable t) {
            packer.close();
            ClientMessagePacker errPacker = this.getPacker(ctx.alloc());
            try {
                ProtocolVersion.LATEST_VER.pack(errPacker);
                this.writeErrorCore(t, errPacker);
                this.write(errPacker, ctx);
            }
            catch (Throwable t2) {
                errPacker.close();
                this.exceptionCaught(ctx, t2);
            }
        }
    }

    private void writeMagic(ChannelHandlerContext ctx) {
        ctx.write((Object)Unpooled.wrappedBuffer((byte[])ClientMessageCommon.MAGIC_BYTES));
    }

    private void write(ClientMessagePacker packer, ChannelHandlerContext ctx) {
        ByteBuf buf = packer.getBuffer();
        ctx.writeAndFlush((Object)buf);
    }

    private void writeError(long requestId, Throwable err, ChannelHandlerContext ctx) {
        LOG.warn("Error processing client request", err);
        ClientMessagePacker packer = this.getPacker(ctx.alloc());
        try {
            assert (err != null);
            packer.packInt(0);
            packer.packLong(requestId);
            this.writeFlags(packer);
            this.writeErrorCore(err, packer);
            this.write(packer, ctx);
        }
        catch (Throwable t) {
            packer.close();
            this.exceptionCaught(ctx, t);
        }
    }

    private void writeErrorCore(Throwable err, ClientMessagePacker packer) {
        if ((err = ExceptionUtils.unwrapCause((Throwable)err)) instanceof IgniteException) {
            IgniteException iex = (IgniteException)err;
            packer.packUuid(iex.traceId());
            packer.packInt(iex.code());
        } else {
            packer.packUuid(UUID.randomUUID());
            packer.packInt(ErrorGroups.Common.UNKNOWN_ERR);
        }
        packer.packString(err.getClass().getName());
        String msg = err.getMessage();
        if (msg == null) {
            packer.packNil();
        } else {
            packer.packString(msg);
        }
        if (this.configuration.sendServerExceptionStackTraceToClient()) {
            packer.packString(ExceptionUtils.getFullStackTrace((Throwable)err));
        } else {
            packer.packNil();
        }
    }

    private ClientMessagePacker getPacker(ByteBufAllocator alloc) {
        return new ClientMessagePacker(alloc.buffer());
    }

    private ClientMessageUnpacker getUnpacker(ByteBuf buf) {
        return new ClientMessageUnpacker(buf);
    }

    private void processOperation(ChannelHandlerContext ctx, ClientMessageUnpacker in, ClientMessagePacker out) {
        long requestId = -1L;
        try {
            int opCode = in.unpackInt();
            requestId = in.unpackLong();
            out.packInt(0);
            out.packLong(requestId);
            this.writeFlags(out);
            out.packNil();
            CompletableFuture fut = this.processOperation(in, out, opCode);
            if (fut == null) {
                this.write(out, ctx);
            } else {
                long reqId = requestId;
                fut.whenComplete((res, err) -> {
                    if (err != null) {
                        out.close();
                        this.writeError(reqId, (Throwable)err, ctx);
                    } else {
                        this.write(out, ctx);
                    }
                });
            }
        }
        catch (Throwable t) {
            out.close();
            this.writeError(requestId, t, ctx);
        }
    }

    private CompletableFuture processOperation(ClientMessageUnpacker in, ClientMessagePacker out, int opCode) throws IgniteInternalCheckedException {
        switch (opCode) {
            case 1: {
                return null;
            }
            case 3: {
                return ClientTablesGetRequest.process(out, (IgniteTables)this.igniteTables);
            }
            case 5: {
                return ClientSchemasGetRequest.process(in, out, (IgniteTables)this.igniteTables);
            }
            case 4: {
                return ClientTableGetRequest.process(in, out, (IgniteTables)this.igniteTables);
            }
            case 10: {
                return ClientTupleUpsertRequest.process(in, (IgniteTables)this.igniteTables, this.resources);
            }
            case 12: {
                return ClientTupleGetRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 13: {
                return ClientTupleUpsertAllRequest.process(in, (IgniteTables)this.igniteTables, this.resources);
            }
            case 15: {
                return ClientTupleGetAllRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 16: {
                return ClientTupleGetAndUpsertRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 18: {
                return ClientTupleInsertRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 20: {
                return ClientTupleInsertAllRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 22: {
                return ClientTupleReplaceRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 24: {
                return ClientTupleReplaceExactRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 26: {
                return ClientTupleGetAndReplaceRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 28: {
                return ClientTupleDeleteRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 29: {
                return ClientTupleDeleteAllRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 30: {
                return ClientTupleDeleteExactRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 31: {
                return ClientTupleDeleteAllExactRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 32: {
                return ClientTupleGetAndDeleteRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 33: {
                return ClientTupleContainsKeyRequest.process(in, out, (IgniteTables)this.igniteTables, this.resources);
            }
            case 34: {
                return ClientJdbcExecuteRequest.execute(in, out, this.jdbcQueryEventHandler);
            }
            case 36: {
                return ClientJdbcExecuteBatchRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 46: {
                return ClientJdbcPreparedStmntBatchRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 35: {
                return ClientJdbcFetchRequest.process(in, out, this.jdbcQueryCursorHandler);
            }
            case 37: {
                return ClientJdbcCloseRequest.process(in, out, this.jdbcQueryCursorHandler);
            }
            case 38: {
                return ClientJdbcTableMetadataRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 39: {
                return ClientJdbcColumnMetadataRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 40: {
                return ClientJdbcSchemasMetadataRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 41: {
                return ClientJdbcPrimaryKeyMetadataRequest.process(in, out, this.jdbcQueryEventHandler);
            }
            case 42: {
                return ClientJdbcQueryMetadataRequest.process(in, out, this.jdbcQueryCursorHandler);
            }
            case 43: {
                return ClientTransactionBeginRequest.process(out, this.igniteTransactions, this.resources);
            }
            case 44: {
                return ClientTransactionCommitRequest.process(in, this.resources);
            }
            case 45: {
                return ClientTransactionRollbackRequest.process(in, this.resources);
            }
            case 47: {
                return ClientComputeExecuteRequest.process(in, out, this.compute, this.clusterService);
            }
            case 49: {
                return ClientComputeExecuteColocatedRequest.process(in, out, this.compute, (IgniteTables)this.igniteTables);
            }
            case 48: {
                return ClientClusterGetNodesRequest.process(out, this.clusterService);
            }
            case 50: {
                return ClientSqlExecuteRequest.process(in, out, this.sql, this.resources);
            }
            case 51: {
                return ClientSqlCursorNextPageRequest.process(in, out, this.resources);
            }
            case 52: {
                return ClientSqlCursorCloseRequest.process(in, this.resources);
            }
            case 53: {
                return ClientTablePartitionAssignmentGetRequest.process(in, out, this.igniteTables);
            }
        }
        throw new IgniteException(ErrorGroups.Client.PROTOCOL_ERR, "Unexpected operation code: " + opCode);
    }

    private void writeFlags(ClientMessagePacker out) {
        int flags = ResponseFlags.getFlags((boolean)this.partitionAssignmentChanged.compareAndSet(true, false));
        out.packInt(flags);
    }

    private void onPartitionAssignmentChanged(IgniteTablesInternal tables) {
        this.partitionAssignmentChanged.set(true);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.warn("Exception in client connector pipeline: " + cause.getMessage(), cause);
        ctx.close();
    }
}

