/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.affinity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiPredicate;
import java.util.function.IntFunction;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.network.ClusterNode;

public class RendezvousAffinityFunction {
    private static final IgniteLogger LOG = Loggers.forClass(RendezvousAffinityFunction.class);
    private static final Comparator<IgniteBiTuple<Long, ClusterNode>> COMPARATOR = new HashComparator();
    public static final int MAX_PARTITIONS_COUNT = 65000;
    private static boolean exclNeighborsWarn;

    public static Object resolveNodeHash(ClusterNode node) {
        return node.name();
    }

    public static <T extends Collection<ClusterNode>> T assignPartition(int part, List<ClusterNode> nodes, int replicas, Map<String, Collection<ClusterNode>> neighborhoodCache, boolean exclNeighbors, BiPredicate<ClusterNode, T> nodeFilter, IntFunction<T> aggregator) {
        ClusterNode node;
        if (nodes.size() <= 1) {
            Collection res = (Collection)aggregator.apply(1);
            res.addAll(nodes);
            return (T)res;
        }
        IgniteBiTuple[] hashArr = new IgniteBiTuple[nodes.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            ClusterNode node2 = nodes.get(i);
            Object nodeHash = RendezvousAffinityFunction.resolveNodeHash(node2);
            long hash = RendezvousAffinityFunction.hash(nodeHash.hashCode(), part);
            hashArr[i] = new IgniteBiTuple((Object)hash, (Object)node2);
        }
        int effectiveReplicas = replicas == Integer.MAX_VALUE ? nodes.size() : Math.min(replicas, nodes.size());
        LazyLinearSortedContainer sortedNodes = new LazyLinearSortedContainer(hashArr, effectiveReplicas);
        if (replicas == Integer.MAX_VALUE) {
            return RendezvousAffinityFunction.replicatedAssign(nodes, sortedNodes, aggregator);
        }
        Iterator it = sortedNodes.iterator();
        Collection res = (Collection)aggregator.apply(effectiveReplicas);
        HashSet<ClusterNode> allNeighbors = new HashSet<ClusterNode>();
        ClusterNode first = (ClusterNode)it.next();
        res.add(first);
        if (exclNeighbors) {
            allNeighbors.addAll(neighborhoodCache.get(first.id()));
        }
        if (replicas > 1) {
            while (it.hasNext() && res.size() < effectiveReplicas) {
                node = (ClusterNode)it.next();
                if (exclNeighbors) {
                    if (allNeighbors.contains(node)) continue;
                    res.add(node);
                    allNeighbors.addAll(neighborhoodCache.get(node.id()));
                    continue;
                }
                if (nodeFilter != null && !nodeFilter.test(node, (ClusterNode)res)) continue;
                res.add(node);
                if (!exclNeighbors) continue;
                allNeighbors.addAll(neighborhoodCache.get(node.id()));
            }
        }
        if (res.size() < effectiveReplicas && nodes.size() >= effectiveReplicas && exclNeighbors) {
            it = sortedNodes.iterator();
            it.next();
            while (it.hasNext() && res.size() < effectiveReplicas) {
                node = (ClusterNode)it.next();
                if (res.contains(node)) continue;
                res.add(node);
            }
            if (!exclNeighborsWarn) {
                LOG.warn("Affinity function excludeNeighbors property is ignored because topology has no enough nodes to assign all replicas.", new Object[0]);
                exclNeighborsWarn = true;
            }
        }
        assert (res.size() <= effectiveReplicas);
        return (T)res;
    }

    private static <T extends Collection<ClusterNode>> T replicatedAssign(List<ClusterNode> nodes, Iterable<ClusterNode> sortedNodes, IntFunction<T> aggregator) {
        ClusterNode first = sortedNodes.iterator().next();
        Collection res = (Collection)aggregator.apply(nodes.size());
        res.add(first);
        for (ClusterNode n : nodes) {
            if (n.equals((Object)first)) continue;
            res.add(n);
        }
        assert (res.size() == nodes.size()) : "Not enough replicas: " + res.size();
        return (T)res;
    }

    private static long hash(int key0, int key1) {
        long key = (long)key0 & 0xFFFFFFFFL | ((long)key1 & 0xFFFFFFFFL) << 32;
        key = (key ^ 0xFFFFFFFFFFFFFFFFL) + (key << 21);
        key ^= key >>> 24;
        key += (key << 3) + (key << 8);
        key ^= key >>> 14;
        key += (key << 2) + (key << 4);
        key ^= key >>> 28;
        key += key << 31;
        return key;
    }

    public static List<List<ClusterNode>> assignPartitions(Collection<ClusterNode> currentTopologySnapshot, int partitions, int replicas, boolean exclNeighbors, BiPredicate<ClusterNode, List<ClusterNode>> nodeFilter) {
        return RendezvousAffinityFunction.assignPartitions(currentTopologySnapshot, partitions, replicas, exclNeighbors, nodeFilter, ArrayList::new);
    }

    public static <T extends Collection<ClusterNode>> List<T> assignPartitions(Collection<ClusterNode> currentTopologySnapshot, int partitions, int replicas, boolean exclNeighbors, BiPredicate<ClusterNode, T> nodeFilter, IntFunction<T> aggregator) {
        assert (partitions <= 65000) : "partitions <= 65000";
        assert (partitions > 0) : "parts > 0";
        assert (replicas > 0) : "replicas > 0";
        ArrayList<T> assignments = new ArrayList<T>(partitions);
        Map<String, Collection<ClusterNode>> neighborhoodCache = exclNeighbors ? RendezvousAffinityFunction.neighbors(currentTopologySnapshot) : null;
        ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>(currentTopologySnapshot);
        for (int i = 0; i < partitions; ++i) {
            T partAssignment = RendezvousAffinityFunction.assignPartition(i, nodes, replicas, neighborhoodCache, exclNeighbors, nodeFilter, aggregator);
            assignments.add(partAssignment);
        }
        return assignments;
    }

    public static Map<String, Collection<ClusterNode>> neighbors(Collection<ClusterNode> topSnapshot) {
        HashMap<String, HashSet<ClusterNode>> macMap = new HashMap<String, HashSet<ClusterNode>>(topSnapshot.size(), 1.0f);
        for (ClusterNode node : topSnapshot) {
            String macs = String.valueOf(node.hashCode());
            HashSet<ClusterNode> nodes = (HashSet<ClusterNode>)macMap.get(macs);
            if (nodes == null) {
                nodes = new HashSet<ClusterNode>();
                macMap.put(macs, nodes);
            }
            nodes.add(node);
        }
        HashMap<String, Collection<ClusterNode>> neighbors = new HashMap<String, Collection<ClusterNode>>(topSnapshot.size(), 1.0f);
        for (Collection group : macMap.values()) {
            for (ClusterNode node : group) {
                neighbors.put(node.id(), group);
            }
        }
        return neighbors;
    }

    public String toString() {
        return "U.toString(RendezvousAffinityFunction.class, this)";
    }

    public static int safeAbs(int i) {
        return (i = Math.abs(i)) < 0 ? 0 : i;
    }

    private static class LazyLinearSortedContainer
    implements Iterable<ClusterNode> {
        private final IgniteBiTuple<Long, ClusterNode>[] arr;
        private int sorted;

        LazyLinearSortedContainer(IgniteBiTuple<Long, ClusterNode>[] arr, int needFirstSortedCnt) {
            this.arr = arr;
            if (needFirstSortedCnt > (int)Math.log(arr.length)) {
                Arrays.sort(arr, COMPARATOR);
                this.sorted = arr.length;
            }
        }

        @Override
        public Iterator<ClusterNode> iterator() {
            return new SortIterator();
        }

        private class SortIterator
        implements Iterator<ClusterNode> {
            private int cur;

            private SortIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.cur < LazyLinearSortedContainer.this.arr.length;
            }

            @Override
            public ClusterNode next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (this.cur < LazyLinearSortedContainer.this.sorted) {
                    return (ClusterNode)LazyLinearSortedContainer.this.arr[this.cur++].get2();
                }
                IgniteBiTuple<Long, ClusterNode> min = LazyLinearSortedContainer.this.arr[this.cur];
                int minIdx = this.cur;
                for (int i = this.cur + 1; i < LazyLinearSortedContainer.this.arr.length; ++i) {
                    if (COMPARATOR.compare(LazyLinearSortedContainer.this.arr[i], min) >= 0) continue;
                    minIdx = i;
                    min = LazyLinearSortedContainer.this.arr[i];
                }
                if (minIdx != this.cur) {
                    LazyLinearSortedContainer.this.arr[minIdx] = LazyLinearSortedContainer.this.arr[this.cur];
                    LazyLinearSortedContainer.this.arr[this.cur] = min;
                }
                LazyLinearSortedContainer.this.sorted = this.cur++;
                return (ClusterNode)min.get2();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove doesn't supported");
            }
        }
    }

    private static class HashComparator
    implements Comparator<IgniteBiTuple<Long, ClusterNode>>,
    Serializable {
        private static final long serialVersionUID = 0L;

        private HashComparator() {
        }

        @Override
        public int compare(IgniteBiTuple<Long, ClusterNode> o1, IgniteBiTuple<Long, ClusterNode> o2) {
            return (Long)o1.get1() < (Long)o2.get1() ? -1 : ((Long)o1.get1() > (Long)o2.get1() ? 1 : ((ClusterNode)o1.get2()).name().compareTo(((ClusterNode)o2.get2()).name()));
        }
    }
}

