/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec;

import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.ignite.internal.sql.engine.exec.RowHandler;
import org.apache.ignite.internal.util.ArrayUtils;

public class ArrayRowHandler
implements RowHandler<Object[]> {
    public static final RowHandler<Object[]> INSTANCE = new ArrayRowHandler();

    private ArrayRowHandler() {
    }

    @Override
    public Object get(int field, Object[] row) {
        return row[field];
    }

    @Override
    public void set(int field, Object[] row, Object val) {
        row[field] = val;
    }

    @Override
    public Object[] concat(Object[] left, Object[] right) {
        return ArrayUtils.concat((Object[])left, (Object[])right);
    }

    @Override
    public int columnCount(Object[] row) {
        return row.length;
    }

    @Override
    public String toString(Object[] objects) {
        return "Row" + Arrays.toString(objects);
    }

    @Override
    public RowHandler.RowFactory<Object[]> factory(Type ... types) {
        final int rowLen = types.length;
        return new RowHandler.RowFactory<Object[]>(){

            @Override
            public RowHandler<Object[]> handler() {
                return ArrayRowHandler.this;
            }

            @Override
            public Object[] create() {
                return new Object[rowLen];
            }

            @Override
            public Object[] create(Object ... fields) {
                assert (fields.length == rowLen);
                return fields;
            }
        };
    }
}

