/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory.index.sorted;

import org.apache.ignite.internal.pagememory.tree.IgniteTree;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumns;
import org.apache.ignite.internal.storage.pagememory.index.freelist.IndexColumnsFreeList;
import org.apache.ignite.internal.storage.pagememory.index.sorted.SortedIndexRow;
import org.apache.ignite.lang.IgniteInternalCheckedException;
import org.jetbrains.annotations.Nullable;

class RemoveSortedIndexRowInvokeClosure
implements IgniteTree.InvokeClosure<SortedIndexRow> {
    private final SortedIndexRow sortedIndexRow;
    private final IndexColumnsFreeList freeList;
    private IgniteTree.OperationType operationType = IgniteTree.OperationType.REMOVE;

    public RemoveSortedIndexRowInvokeClosure(SortedIndexRow sortedIndexRow, IndexColumnsFreeList freeList) {
        assert (sortedIndexRow.indexColumns().link() == 0L);
        this.sortedIndexRow = sortedIndexRow;
        this.freeList = freeList;
    }

    public void call(@Nullable SortedIndexRow oldRow) {
        if (oldRow == null) {
            this.operationType = IgniteTree.OperationType.NOOP;
        } else {
            this.sortedIndexRow.indexColumns().link(oldRow.indexColumns().link());
        }
    }

    @Nullable
    public SortedIndexRow newRow() {
        return null;
    }

    public IgniteTree.OperationType operationType() {
        return this.operationType;
    }

    public void afterCompletion() throws IgniteInternalCheckedException {
        IndexColumns indexColumns = this.sortedIndexRow.indexColumns();
        if (indexColumns.link() != 0L) {
            assert (this.operationType == IgniteTree.OperationType.REMOVE);
            this.freeList.removeDataRowByLink(indexColumns.link());
            indexColumns.link(0L);
        }
    }
}

