/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli;

import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.ignite.internal.cli.core.exception.IgniteCliException;

@Singleton
public class CliVersionInfo {
    private final String version;
    private final String product;

    public CliVersionInfo() {
        try (InputStream inputStream = CliVersionInfo.class.getResourceAsStream("/version.properties");){
            Properties prop = new Properties();
            prop.load(inputStream);
            this.version = prop.getProperty("version", "undefined");
            this.product = prop.getProperty("product", "undefined");
        }
        catch (IOException e) {
            throw new IgniteCliException("Can't read version info");
        }
    }

    String version() {
        return this.version;
    }

    String product() {
        return this.product;
    }
}

