/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.node.version;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.call.UrlCallInput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite.internal.rest.api.node.NodeVersion;
import org.apache.ignite.rest.client.api.NodeManagementApi;
import org.apache.ignite.rest.client.invoker.ApiException;

@Singleton
public class NodeVersionCall
implements Call<UrlCallInput, NodeVersion> {
    private final ApiClientFactory clientFactory;

    public NodeVersionCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public CallOutput<NodeVersion> execute(UrlCallInput input) {
        try {
            return DefaultCallOutput.success(this.getNodeVersion(input.getUrl()));
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getUrl()));
        }
    }

    private NodeVersion getNodeVersion(String url) throws ApiException {
        org.apache.ignite.rest.client.model.NodeVersion nodeVersion = new NodeManagementApi(this.clientFactory.getClient(url)).nodeVersion();
        return NodeVersion.builder().version(nodeVersion.getVersion()).product(nodeVersion.getProduct()).build();
    }
}

