/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.marshaller;

import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;
import org.apache.ignite.internal.binarytuple.BinaryTupleReader;
import org.apache.ignite.internal.client.proto.TuplePart;
import org.apache.ignite.internal.client.table.ClientColumn;
import org.apache.ignite.internal.marshaller.MarshallerReader;
import org.jetbrains.annotations.Nullable;

public class ClientMarshallerReader
implements MarshallerReader {
    private final BinaryTupleReader unpacker;
    private final ClientColumn @Nullable [] columns;
    private final TuplePart part;
    private int index;

    public ClientMarshallerReader(BinaryTupleReader unpacker, ClientColumn @Nullable [] columns, TuplePart part) {
        this.unpacker = unpacker;
        this.columns = columns;
        this.part = part;
    }

    public void skipValue() {
        ++this.index;
    }

    public boolean readBoolean() {
        return this.unpacker.booleanValue(this.nextSchemaIndex());
    }

    public Boolean readBooleanBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Boolean.valueOf(this.unpacker.booleanValue(idx));
    }

    public byte readByte() {
        return this.unpacker.byteValue(this.nextSchemaIndex());
    }

    public Byte readByteBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Byte.valueOf(this.unpacker.byteValue(idx));
    }

    public short readShort() {
        return this.unpacker.shortValue(this.nextSchemaIndex());
    }

    public Short readShortBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Short.valueOf(this.unpacker.shortValue(idx));
    }

    public int readInt() {
        return this.unpacker.intValue(this.nextSchemaIndex());
    }

    public Integer readIntBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Integer.valueOf(this.unpacker.intValue(idx));
    }

    public long readLong() {
        return this.unpacker.longValue(this.nextSchemaIndex());
    }

    public Long readLongBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Long.valueOf(this.unpacker.longValue(idx));
    }

    public float readFloat() {
        return this.unpacker.floatValue(this.nextSchemaIndex());
    }

    public Float readFloatBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Float.valueOf(this.unpacker.floatValue(idx));
    }

    public double readDouble() {
        return this.unpacker.doubleValue(this.nextSchemaIndex());
    }

    public Double readDoubleBoxed() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : Double.valueOf(this.unpacker.doubleValue(idx));
    }

    public String readString() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.stringValue(idx);
    }

    public UUID readUuid() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.uuidValue(idx);
    }

    public byte[] readBytes() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.bytesValue(idx);
    }

    public BigDecimal readBigDecimal(int scale) {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.decimalValue(idx, scale);
    }

    public LocalDate readDate() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.dateValue(idx);
    }

    public LocalTime readTime() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.timeValue(idx);
    }

    public Instant readTimestamp() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.timestampValue(idx);
    }

    public LocalDateTime readDateTime() {
        int idx = this.nextSchemaIndex();
        return this.unpacker.hasNullValue(idx) ? null : this.unpacker.dateTimeValue(idx);
    }

    private int nextSchemaIndex() {
        int i = this.index++;
        if (this.columns == null) {
            return i;
        }
        switch (this.part) {
            case KEY: {
                return this.columns[i].keyIndex();
            }
            case VAL: {
                return this.columns[i].valIndex();
            }
        }
        return this.columns[i].schemaIndex();
    }
}

