/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.worker;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.FastTimestamps;
import org.apache.ignite.internal.util.worker.IgniteWorkerListener;
import org.apache.ignite.internal.util.worker.WorkProgressDispatcher;
import org.jetbrains.annotations.Nullable;

public abstract class IgniteWorker
implements Runnable,
WorkProgressDispatcher {
    protected final IgniteLogger log;
    private final String name;
    private final String igniteInstanceName;
    private final IgniteWorkerListener listener;
    private volatile boolean finished;
    protected final AtomicBoolean isCancelled = new AtomicBoolean();
    private volatile Thread runner;
    private volatile long heartbeatTimestamp;
    private static final AtomicLongFieldUpdater<IgniteWorker> HEARTBEAT_UPDATER = AtomicLongFieldUpdater.newUpdater(IgniteWorker.class, "heartbeatTimestamp");
    private final Object mux = new Object();

    protected IgniteWorker(IgniteLogger log, String igniteInstanceName, String name, @Nullable IgniteWorkerListener listener) {
        this.log = log;
        this.igniteInstanceName = igniteInstanceName;
        this.name = name;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final void run() {
        Object object;
        this.updateHeartbeat();
        this.runner = Thread.currentThread();
        this.log.debug("Ignite runnable started [name={}]", this.name);
        try {
            if (this.isCancelled.get()) {
                this.onCancelledBeforeWorkerScheduled();
            }
            if (this.listener != null) {
                this.listener.onStarted(this);
            }
            this.body();
            object = this.mux;
        }
        catch (InterruptedException e2222222222) {
            this.log.debug("Caught interrupted exception", (Throwable)e2222222222);
            Thread.currentThread().interrupt();
            Object e2222222222 = this.mux;
            synchronized (e2222222222) {
                this.finished = true;
                this.mux.notifyAll();
            }
            this.cleanup();
            if (this.listener != null) {
                this.listener.onStopped(this);
            }
            if (this.log.isDebugEnabled()) {
                if (this.isCancelled.get()) {
                    this.log.debug("Ignite runnable finished due to cancellation [threadName={}]", this.name);
                } else if (this.runner.isInterrupted()) {
                    this.log.debug("Ignite runnable finished due to interruption without cancellation [threadName={}]", this.name);
                } else {
                    this.log.debug("Ignite runnable finished normally [threadName={}]", this.name);
                }
            }
            this.runner = null;
        }
        catch (Throwable e) {
            this.log.warn("Runtime error caught during ignite runnable execution [worker={}]", e, this);
            if (e instanceof Error) {
                throw e;
            }
            Object object2 = this.mux;
            {
                catch (Throwable throwable) {
                    Object object3 = this.mux;
                    synchronized (object3) {
                        this.finished = true;
                        this.mux.notifyAll();
                    }
                    this.cleanup();
                    if (this.listener != null) {
                        this.listener.onStopped(this);
                    }
                    if (this.log.isDebugEnabled()) {
                        if (this.isCancelled.get()) {
                            this.log.debug("Ignite runnable finished due to cancellation [threadName={}]", this.name);
                        } else if (this.runner.isInterrupted()) {
                            this.log.debug("Ignite runnable finished due to interruption without cancellation [threadName={}]", this.name);
                        } else {
                            this.log.debug("Ignite runnable finished normally [threadName={}]", this.name);
                        }
                    }
                    this.runner = null;
                    throw throwable;
                }
            }
            synchronized (object2) {
                this.finished = true;
                this.mux.notifyAll();
            }
            this.cleanup();
            if (this.listener != null) {
                this.listener.onStopped(this);
            }
            if (this.log.isDebugEnabled()) {
                if (this.isCancelled.get()) {
                    this.log.debug("Ignite runnable finished due to cancellation [threadName={}]", this.name);
                } else if (this.runner.isInterrupted()) {
                    this.log.debug("Ignite runnable finished due to interruption without cancellation [threadName={}]", this.name);
                } else {
                    this.log.debug("Ignite runnable finished normally [threadName={}]", this.name);
                }
            }
            this.runner = null;
        }
        synchronized (object) {
            this.finished = true;
            this.mux.notifyAll();
        }
        this.cleanup();
        if (this.listener != null) {
            this.listener.onStopped(this);
        }
        if (this.log.isDebugEnabled()) {
            if (this.isCancelled.get()) {
                this.log.debug("Ignite runnable finished due to cancellation [threadName={}]", this.name);
            } else if (this.runner.isInterrupted()) {
                this.log.debug("Ignite runnable finished due to interruption without cancellation [threadName={}]", this.name);
            } else {
                this.log.debug("Ignite runnable finished normally [threadName={}]", this.name);
            }
        }
        this.runner = null;
    }

    protected abstract void body() throws InterruptedException;

    protected void cleanup() {
    }

    @Nullable
    public Thread runner() {
        return this.runner;
    }

    public String igniteInstanceName() {
        return this.igniteInstanceName;
    }

    public String name() {
        return this.name;
    }

    public void cancel() {
        this.log.debug("Cancelling ignite runnable [worker={}]", this);
        this.onCancel(this.isCancelled.compareAndSet(false, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException {
        this.log.debug("Joining ignite runnable [worker={}]", this);
        if (this.runner == null && this.isCancelled.get() || this.finished) {
            return;
        }
        Object object = this.mux;
        synchronized (object) {
            while (!this.finished) {
                this.mux.wait();
            }
        }
    }

    public boolean isCancelled() {
        Thread runner = this.runner;
        return this.isCancelled.get() || runner != null && runner.isInterrupted();
    }

    public boolean isDone() {
        return this.finished;
    }

    @Override
    public long heartbeat() {
        return this.heartbeatTimestamp;
    }

    @Override
    public void updateHeartbeat() {
        long currentTimestamp = FastTimestamps.coarseCurrentTimeMillis();
        long heartbeatTimestamp = this.heartbeatTimestamp;
        while (heartbeatTimestamp < currentTimestamp) {
            if (HEARTBEAT_UPDATER.compareAndSet(this, heartbeatTimestamp, currentTimestamp)) {
                return;
            }
            heartbeatTimestamp = this.heartbeatTimestamp;
        }
    }

    @Override
    public void blockingSectionBegin() {
        this.heartbeatTimestamp = Long.MAX_VALUE;
    }

    @Override
    public void blockingSectionEnd() {
        this.heartbeatTimestamp = FastTimestamps.coarseCurrentTimeMillis();
    }

    protected void onIdle() {
        if (this.listener != null) {
            this.listener.onIdle(this);
        }
    }

    protected void onCancel(boolean firstCancelRequest) {
        Thread runner = this.runner;
        if (runner != null) {
            runner.interrupt();
        }
    }

    protected void onCancelledBeforeWorkerScheduled() {
        Thread runner = this.runner;
        assert (runner != null) : this;
        runner.interrupt();
    }

    public String toString() {
        Thread runner = this.runner;
        return S.toString(IgniteWorker.class, this, "hashCode", (Object)this.hashCode(), "interrupted", runner != null ? Boolean.valueOf(runner.isInterrupted()) : "unknown", "runner", (Object)(runner == null ? "null" : runner.getName()));
    }
}

