/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.sql;

import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.ignite.catalog.ColumnSorted;
import org.apache.ignite.catalog.SortOrder;
import org.apache.ignite.internal.catalog.sql.Name;
import org.apache.ignite.internal.catalog.sql.QueryContext;
import org.apache.ignite.internal.catalog.sql.QueryPart;
import org.apache.ignite.internal.catalog.sql.QueryUtils;

class IndexColumnImpl
extends QueryPart {
    private static final Pattern SPACES = Pattern.compile("\\s+");
    private final ColumnSorted wrapped;

    public static IndexColumnImpl wrap(ColumnSorted column) {
        return new IndexColumnImpl(column);
    }

    private IndexColumnImpl(ColumnSorted wrapped) {
        this.wrapped = wrapped;
    }

    public static List<ColumnSorted> parseIndexColumnList(String columnList) {
        return QueryUtils.splitByComma(columnList).stream().map(IndexColumnImpl::parseCol).collect(Collectors.toList());
    }

    private static ColumnSorted parseCol(String columnRaw) {
        String[] split = SPACES.split(columnRaw, 2);
        String columnName = split[0].trim();
        if (split.length < 2) {
            return ColumnSorted.column((String)columnName);
        }
        SortOrder sortOrder = IndexColumnImpl.parseSortOrder(split[1].trim().toLowerCase());
        return ColumnSorted.column((String)columnName, (SortOrder)sortOrder);
    }

    private static SortOrder parseSortOrder(String sortOrder) {
        String[] split = SPACES.split(sortOrder);
        if (split.length > 0) {
            boolean asc;
            switch (split[0].trim()) {
                case "asc": {
                    asc = true;
                    break;
                }
                case "desc": {
                    asc = false;
                    break;
                }
                case "nulls": {
                    if (split.length > 1) {
                        String secondToken = split[1].trim();
                        if ("first".equals(secondToken)) {
                            return SortOrder.NULLS_FIRST;
                        }
                        if ("last".equals(secondToken)) {
                            return SortOrder.NULLS_LAST;
                        }
                    }
                    return SortOrder.DEFAULT;
                }
                default: {
                    return SortOrder.DEFAULT;
                }
            }
            if (split.length > 2 && "nulls".equals(split[1].trim())) {
                String thirdToken = split[2].trim();
                if ("first".equals(thirdToken)) {
                    return asc ? SortOrder.ASC_NULLS_FIRST : SortOrder.DESC_NULLS_FIRST;
                }
                if ("last".equals(thirdToken)) {
                    return asc ? SortOrder.ASC_NULLS_LAST : SortOrder.DESC_NULLS_LAST;
                }
            }
            return asc ? SortOrder.ASC : SortOrder.DESC;
        }
        return SortOrder.DEFAULT;
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.visit(new Name(this.wrapped.columnName()));
        SortOrder sortOrder = this.wrapped.sortOrder();
        if (sortOrder != null && sortOrder != SortOrder.DEFAULT) {
            ctx.sql(" ").sql(sortOrder.sql());
        }
    }
}

