/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.io.netty.handler.ssl;

import org.apache.ignite.shaded.io.netty.buffer.ByteBuf;
import org.apache.ignite.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.ignite.shaded.io.netty.buffer.ByteBufUtil;
import org.apache.ignite.shaded.io.netty.channel.AbstractCoalescingBufferQueue;
import org.apache.ignite.shaded.io.netty.channel.Channel;
import org.apache.ignite.shaded.io.netty.util.internal.PlatformDependent;

abstract class SslHandlerCoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final boolean wantsDirectBuffer;

    SslHandlerCoalescingBufferQueue(Channel channel, int initSize, boolean wantsDirectBuffer) {
        super(channel, initSize);
        this.wantsDirectBuffer = wantsDirectBuffer;
    }

    protected abstract int wrapDataSize();

    @Override
    protected ByteBuf compose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next) {
        return SslHandlerCoalescingBufferQueue.attemptCopyToCumulation(cumulation, next, this.wrapDataSize()) ? cumulation : this.copyAndCompose(alloc, cumulation, next);
    }

    @Override
    protected ByteBuf composeFirst(ByteBufAllocator allocator, ByteBuf first, int bufferSize) {
        ByteBuf newFirst = this.wantsDirectBuffer ? allocator.directBuffer(bufferSize) : allocator.heapBuffer(bufferSize);
        try {
            newFirst.writeBytes(first);
        }
        catch (Throwable cause) {
            newFirst.release();
            PlatformDependent.throwException(cause);
        }
        assert (!first.isReadable());
        first.release();
        return newFirst;
    }

    @Override
    protected ByteBuf removeEmptyValue() {
        return null;
    }

    private static boolean attemptCopyToCumulation(ByteBuf cumulation, ByteBuf next, int wrapDataSize) {
        int inReadableBytes = next.readableBytes();
        if (inReadableBytes == 0) {
            next.release();
            return true;
        }
        int cumulationCapacity = cumulation.capacity();
        if (wrapDataSize - cumulation.readableBytes() >= inReadableBytes && (cumulation.isWritable(inReadableBytes) && cumulationCapacity >= wrapDataSize || cumulationCapacity < wrapDataSize && ByteBufUtil.ensureWritableSuccess(cumulation.ensureWritable(inReadableBytes, false)))) {
            cumulation.writeBytes(next);
            next.release();
            return true;
        }
        return false;
    }
}

