/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.catalog.sql;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.ignite.shaded.org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.shaded.org.apache.ignite.catalog.definitions.TableDefinition;
import org.apache.ignite.shaded.org.apache.ignite.catalog.definitions.ZoneDefinition;
import org.apache.ignite.shaded.org.apache.ignite.internal.catalog.sql.CreateFromAnnotationsImpl;
import org.apache.ignite.shaded.org.apache.ignite.internal.catalog.sql.CreateFromDefinitionImpl;
import org.apache.ignite.shaded.org.apache.ignite.internal.catalog.sql.DropTableImpl;
import org.apache.ignite.shaded.org.apache.ignite.internal.catalog.sql.DropZoneImpl;
import org.apache.ignite.shaded.org.apache.ignite.internal.catalog.sql.Option;
import org.apache.ignite.shaded.org.apache.ignite.internal.catalog.sql.SelectFromView;
import org.apache.ignite.shaded.org.apache.ignite.internal.catalog.sql.TableDefinitionCollector;
import org.apache.ignite.shaded.org.apache.ignite.internal.lang.IgniteExceptionMapperUtil;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.CompletableFutures;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.ExceptionUtils;
import org.apache.ignite.shaded.org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.shaded.org.apache.ignite.sql.SqlRow;
import org.apache.ignite.shaded.org.apache.ignite.table.IgniteTables;
import org.apache.ignite.shaded.org.apache.ignite.table.QualifiedName;
import org.apache.ignite.shaded.org.apache.ignite.table.Table;

public class IgniteCatalogSqlImpl
implements IgniteCatalog {
    private final IgniteSql sql;
    private final IgniteTables tables;

    public IgniteCatalogSqlImpl(IgniteSql sql, IgniteTables tables) {
        this.sql = sql;
        this.tables = tables;
    }

    @Override
    public CompletableFuture<Table> createTableAsync(Class<?> keyClass, Class<?> valueClass) {
        return new CreateFromAnnotationsImpl(this.sql).processKeyValueClasses(keyClass, valueClass).executeAsync().thenCompose(tableZoneId -> this.tables.tableAsync(tableZoneId.tableName()));
    }

    @Override
    public CompletableFuture<Table> createTableAsync(Class<?> recordClass) {
        return new CreateFromAnnotationsImpl(this.sql).processRecordClass(recordClass).executeAsync().thenCompose(tableZoneId -> this.tables.tableAsync(tableZoneId.tableName()));
    }

    @Override
    public CompletableFuture<Table> createTableAsync(TableDefinition definition) {
        return new CreateFromDefinitionImpl(this.sql).from(definition).executeAsync().thenCompose(tableZoneId -> this.tables.tableAsync(tableZoneId.tableName()));
    }

    @Override
    public Table createTable(Class<?> recordClass) {
        return IgniteCatalogSqlImpl.join(this.createTableAsync(recordClass));
    }

    @Override
    public Table createTable(Class<?> keyClass, Class<?> valueClass) {
        return IgniteCatalogSqlImpl.join(this.createTableAsync(keyClass, valueClass));
    }

    @Override
    public Table createTable(TableDefinition definition) {
        return IgniteCatalogSqlImpl.join(this.createTableAsync(definition));
    }

    @Override
    public CompletableFuture<TableDefinition> tableDefinitionAsync(QualifiedName tableName) {
        TableDefinitionCollector collector = new TableDefinitionCollector(tableName, this.sql);
        return collector.collectDefinition();
    }

    @Override
    public TableDefinition tableDefinition(QualifiedName tableName) {
        return IgniteCatalogSqlImpl.join(this.tableDefinitionAsync(tableName));
    }

    @Override
    public CompletableFuture<Void> createZoneAsync(ZoneDefinition definition) {
        return new CreateFromDefinitionImpl(this.sql).from(definition).executeAsync().thenApply(unused -> null);
    }

    @Override
    public void createZone(ZoneDefinition definition) {
        IgniteCatalogSqlImpl.join(this.createZoneAsync(definition));
    }

    @Override
    public CompletableFuture<ZoneDefinition> zoneDefinitionAsync(String zoneName) {
        List<String> zoneViewColumns = List.of("ZONE_PARTITIONS", "ZONE_REPLICAS", "ZONE_QUORUM_SIZE", "DATA_NODES_AUTO_ADJUST_SCALE_UP", "DATA_NODES_AUTO_ADJUST_SCALE_DOWN", "DATA_NODES_FILTER", "ZONE_CONSISTENCY_MODE");
        return ((CompletableFuture)new SelectFromView<ZoneDefinition.Builder>(this.sql, zoneViewColumns, "ZONES", Option.name(zoneName), row -> IgniteCatalogSqlImpl.toZoneDefinitionBuilder(zoneName, row)).executeAsync().thenApply(zoneDefinitions -> {
            if (zoneDefinitions.isEmpty()) {
                return null;
            }
            assert (zoneDefinitions.size() == 1);
            return (ZoneDefinition.Builder)zoneDefinitions.get(0);
        })).thenCompose(zoneDefinition -> {
            if (zoneDefinition == null) {
                return CompletableFutures.nullCompletedFuture();
            }
            return new SelectFromView<String>(this.sql, List.of("STORAGE_PROFILE"), "ZONE_STORAGE_PROFILES", Option.zoneName(zoneName), row -> row.stringValue("STORAGE_PROFILE")).executeAsync().thenApply(profiles -> zoneDefinition.storageProfiles(String.join((CharSequence)", ", profiles)).build());
        });
    }

    @Override
    public ZoneDefinition zoneDefinition(String zoneName) {
        return IgniteCatalogSqlImpl.join(this.zoneDefinitionAsync(zoneName));
    }

    @Override
    public CompletableFuture<Void> dropTableAsync(TableDefinition definition) {
        return new DropTableImpl(this.sql).name(definition.qualifiedName()).ifExists().executeAsync().thenApply(unused -> null);
    }

    @Override
    public CompletableFuture<Void> dropTableAsync(QualifiedName name) {
        return new DropTableImpl(this.sql).name(name).ifExists().executeAsync().thenApply(unused -> null);
    }

    @Override
    public void dropTable(TableDefinition definition) {
        IgniteCatalogSqlImpl.join(this.dropTableAsync(definition));
    }

    @Override
    public void dropTable(QualifiedName name) {
        IgniteCatalogSqlImpl.join(this.dropTableAsync(name));
    }

    @Override
    public CompletableFuture<Void> dropZoneAsync(ZoneDefinition definition) {
        return new DropZoneImpl(this.sql).name(definition.zoneName()).ifExists().executeAsync().thenApply(unused -> null);
    }

    @Override
    public CompletableFuture<Void> dropZoneAsync(String name) {
        return new DropZoneImpl(this.sql).name(name).ifExists().executeAsync().thenApply(unused -> null);
    }

    @Override
    public void dropZone(ZoneDefinition definition) {
        IgniteCatalogSqlImpl.join(this.dropZoneAsync(definition));
    }

    @Override
    public void dropZone(String name) {
        IgniteCatalogSqlImpl.join(this.dropZoneAsync(name));
    }

    private static ZoneDefinition.Builder toZoneDefinitionBuilder(String zoneName, SqlRow row) {
        int partitions = row.intValue("ZONE_PARTITIONS");
        int replicas = row.intValue("ZONE_REPLICAS");
        int quorumsSize = row.intValue("ZONE_QUORUM_SIZE");
        int dataNodesAutoAdjustScaleUp = row.intValue("DATA_NODES_AUTO_ADJUST_SCALE_UP");
        int dataNodesAutoAdjustScaleDown = row.intValue("DATA_NODES_AUTO_ADJUST_SCALE_DOWN");
        String filter = row.stringValue("DATA_NODES_FILTER");
        String consistencyMode = row.stringValue("ZONE_CONSISTENCY_MODE");
        return ZoneDefinition.builder(zoneName).partitions(partitions).replicas(replicas).quorumSize(quorumsSize).dataNodesAutoAdjustScaleUp(dataNodesAutoAdjustScaleUp).dataNodesAutoAdjustScaleDown(dataNodesAutoAdjustScaleDown).filter(filter).consistencyMode(consistencyMode);
    }

    private static <R> R join(CompletableFuture<R> future) {
        try {
            return future.join();
        }
        catch (CompletionException e) {
            throw (RuntimeException)ExceptionUtils.sneakyThrow(IgniteExceptionMapperUtil.mapToPublicException(ExceptionUtils.unwrapCause(e)));
        }
    }
}

