/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.shaded.org.apache.ignite.internal.client.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.ClientChannel;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.ReliableChannel;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.proto.ProtocolBitmaskFeature;
import org.apache.ignite.shaded.org.apache.ignite.internal.client.table.ClientTable;
import org.apache.ignite.shaded.org.apache.ignite.internal.marshaller.MarshallersProvider;
import org.apache.ignite.shaded.org.apache.ignite.internal.util.ViewUtils;
import org.apache.ignite.shaded.org.apache.ignite.table.IgniteTables;
import org.apache.ignite.shaded.org.apache.ignite.table.QualifiedName;
import org.apache.ignite.shaded.org.apache.ignite.table.Table;

public class ClientTables
implements IgniteTables {
    private final ReliableChannel ch;
    private final MarshallersProvider marshallers;
    private final int sqlPartitionAwarenessMetadataCacheSize;

    public ClientTables(ReliableChannel ch, MarshallersProvider marshallers, int sqlPartitionAwarenessMetadataCacheSize) {
        this.ch = ch;
        this.marshallers = marshallers;
        this.sqlPartitionAwarenessMetadataCacheSize = sqlPartitionAwarenessMetadataCacheSize;
    }

    @Override
    public List<Table> tables() {
        return ViewUtils.sync(this.tablesAsync());
    }

    @Override
    public CompletableFuture<List<Table>> tablesAsync() {
        return this.ch.serviceAsync(ch -> ClientTables.useQualifiedNames(ch) ? 71 : 3, 3, null, r -> {
            ClientMessageUnpacker in = r.in();
            int cnt = in.unpackInt();
            ArrayList<ClientTable> res = new ArrayList<ClientTable>(cnt);
            boolean unpackQualifiedNames = ClientTables.useQualifiedNames(r.clientChannel());
            for (int i = 0; i < cnt; ++i) {
                int tableId = in.unpackInt();
                QualifiedName name = unpackQualifiedNames ? in.unpackQualifiedName() : QualifiedName.parse(in.unpackString());
                res.add(new ClientTable(this.ch, this.marshallers, tableId, name, this.sqlPartitionAwarenessMetadataCacheSize));
            }
            return res;
        });
    }

    @Override
    public Table table(QualifiedName name) {
        return ViewUtils.sync(this.tableAsync(name));
    }

    @Override
    public CompletableFuture<Table> tableAsync(QualifiedName name) {
        Objects.requireNonNull(name);
        return this.ch.serviceAsync(ch -> ClientTables.useQualifiedNames(ch) ? 72 : 4, 4, w -> {
            if (ClientTables.useQualifiedNames(w.clientChannel())) {
                w.out().packQualifiedName(name);
            } else {
                w.out().packString(name.objectName());
            }
        }, r -> {
            if (r.in().tryUnpackNil()) {
                return null;
            }
            int tableId = r.in().unpackInt();
            boolean unpackQualifiedNames = ClientTables.useQualifiedNames(r.clientChannel());
            QualifiedName qname = unpackQualifiedNames ? r.in().unpackQualifiedName() : QualifiedName.parse(r.in().unpackString());
            return new ClientTable(this.ch, this.marshallers, tableId, qname, this.sqlPartitionAwarenessMetadataCacheSize);
        });
    }

    private static boolean useQualifiedNames(ClientChannel ch) {
        return ch.protocolContext().isFeatureSupported(ProtocolBitmaskFeature.TABLE_GET_REQS_USE_QUALIFIED_NAME);
    }
}

