/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.message;

import java.util.List;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.message.EnlistedPartitionGroupMessage;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxMetaMessage;
import org.apache.ignite.internal.tx.message.TxMetaMessageBuilder;

class TxMetaMessageDeserializer
implements MessageDeserializer<TxMetaMessage> {
    private final TxMetaMessageBuilder msg;

    TxMetaMessageDeserializer(TxMessagesFactory messageFactory) {
        this.msg = messageFactory.txMetaMessage();
    }

    public Class<TxMetaMessage> klass() {
        return TxMetaMessage.class;
    }

    public TxMetaMessage getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTimestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readList("enlistedPartitions", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.enlistedPartitions((List<EnlistedPartitionGroupMessage>)tmp);
                reader.incrementState();
            }
            case 2: {
                int shiftedId = reader.readInt("txState");
                if (!reader.isLastRead()) {
                    return false;
                }
                TxState tmp = shiftedId == 0 ? null : TxState.fromId(shiftedId - 1);
                this.msg.txState(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(TxMetaMessage.class);
    }
}

