/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.exception.handler.replacement;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.validation.exceptions.ConstraintExceptionHandler;
import jakarta.inject.Singleton;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.apache.ignite.internal.rest.api.InvalidParam;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;

@Singleton
@Replaces(value=ConstraintExceptionHandler.class)
@Requires(classes={ConstraintViolationException.class, ExceptionHandler.class})
public class ConstraintExceptionHandlerReplacement
implements ExceptionHandler<ConstraintViolationException, HttpResponse<?>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, ConstraintViolationException exception) {
        Set<InvalidParam> invalidParams = exception.getConstraintViolations().stream().map(it -> new InvalidParam(it.getPropertyPath().toString(), ConstraintExceptionHandlerReplacement.buildMessage(it))).collect(Collectors.toSet());
        return HttpProblemResponse.from(Problem.fromHttpCode(HttpCode.BAD_REQUEST).detail("Validation failed").invalidParams(invalidParams));
    }

    private static String buildMessage(ConstraintViolation<?> violation) {
        Path propertyPath = violation.getPropertyPath();
        StringBuilder message = new StringBuilder();
        Iterator i = propertyPath.iterator();
        while (i.hasNext()) {
            Path.Node node = (Path.Node)i.next();
            if (node.getKind() == ElementKind.METHOD || node.getKind() == ElementKind.CONSTRUCTOR) continue;
            message.append(node.getName());
            if (node.getIndex() != null) {
                message.append(String.format("[%d]", node.getIndex()));
            }
            if (!i.hasNext()) continue;
            message.append('.');
        }
        message.append(": ").append(violation.getMessage());
        return message.toString();
    }
}

