/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class TimeZoneCompiledPattern
extends CompiledPattern {
    private final boolean upperCase;

    public TimeZoneCompiledPattern(Set<PatternModifier> modifiers, boolean upperCase) {
        super(ChronoUnitEnum.TIMEZONE_MINUTES, modifiers);
        this.upperCase = upperCase;
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        String stringValue = String.format(locale, "%3s", dateTime.getZone().getDisplayName(TextStyle.SHORT, Locale.US).toUpperCase(locale));
        if (this.upperCase) {
            return stringValue.toUpperCase(Locale.US);
        }
        return stringValue;
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        throw new ParseException("TZ pattern is not supported in parsing datetime values", inputPosition.getIndex());
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return 2;
    }
}

