/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.client.handler.requests.compute;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.ignite.client.handler.ClientContext;
import org.apache.ignite.client.handler.NotificationSender;
import org.apache.ignite.client.handler.ResponseWriter;
import org.apache.ignite.client.handler.requests.compute.ClientComputeGetStateRequest;
import org.apache.ignite.compute.JobState;
import org.apache.ignite.compute.TaskDescriptor;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.internal.client.proto.ClientComputeJobPacker;
import org.apache.ignite.internal.client.proto.ClientComputeJobUnpacker;
import org.apache.ignite.internal.client.proto.ClientMessagePacker;
import org.apache.ignite.internal.client.proto.ClientMessageUnpacker;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.HybridTimestampProvider;
import org.apache.ignite.internal.compute.IgniteComputeInternal;
import org.apache.ignite.internal.compute.MarshallerProvider;
import org.apache.ignite.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite.internal.compute.events.ComputeEventMetadataBuilder;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.marshalling.Marshaller;

public class ClientComputeExecuteMapReduceRequest {
    private static final IgniteLogger LOG = Loggers.forClass(ClientComputeExecuteMapReduceRequest.class);

    public static CompletableFuture<ResponseWriter> process(ClientMessageUnpacker in, IgniteComputeInternal compute, NotificationSender notificationSender, ClientContext clientContext) {
        List deploymentUnits = in.unpackDeploymentUnits();
        String taskClassName = in.unpackString();
        ComputeJobDataHolder arg = ClientComputeJobUnpacker.unpackJobArgumentWithoutMarshaller((ClientMessageUnpacker)in);
        TaskDescriptor taskDescriptor = TaskDescriptor.builder((String)taskClassName).units(deploymentUnits).build();
        ComputeEventMetadataBuilder metadataBuilder = ComputeEventMetadata.builder((ComputeEventMetadata.Type)ComputeEventMetadata.Type.MAP_REDUCE).eventUser(clientContext.userDetails()).clientAddress(clientContext.remoteAddress().toString());
        TaskExecution execution = compute.submitMapReduceInternal(taskDescriptor, metadataBuilder, (Object)arg, null);
        ClientComputeExecuteMapReduceRequest.sendTaskResult((TaskExecution<Object>)execution, notificationSender);
        CompletionStage idsAsync = execution.idsAsync().handle((ids, ex) -> ex == null ? ids : Collections.emptyList());
        return execution.idAsync().thenCompose(arg_0 -> ClientComputeExecuteMapReduceRequest.lambda$process$3((CompletableFuture)idsAsync, arg_0));
    }

    private static void packJobIds(ClientMessagePacker out, List<UUID> ids) {
        out.packInt(ids.size());
        for (UUID uuid : ids) {
            out.packUuid(uuid);
        }
    }

    private static void sendTaskResult(TaskExecution<Object> execution, NotificationSender notificationSender) {
        execution.resultAsync().whenComplete((val, err) -> execution.stateAsync().whenComplete((state, errState) -> execution.statesAsync().whenComplete((states, errStates) -> {
            try {
                notificationSender.sendNotification(w -> {
                    Marshaller resultMarshaller = ((MarshallerProvider)execution).resultMarshaller();
                    ClientComputeJobPacker.packJobResult((Object)val, (Marshaller)resultMarshaller, (ClientMessagePacker)w);
                    ClientComputeGetStateRequest.packTaskState(w, state);
                    ClientComputeExecuteMapReduceRequest.packJobStates(w, states);
                }, (Throwable)IgniteUtils.firstNotNull((Object[])new Throwable[]{err, errState, errStates}), ((HybridTimestampProvider)execution).hybridTimestamp());
            }
            catch (Throwable t) {
                LOG.error("Failed to send task result notification: " + t.getMessage(), t);
            }
        })));
    }

    private static void packJobStates(ClientMessagePacker w, List<JobState> states) {
        w.packInt(states.size());
        for (JobState state : states) {
            ClientComputeGetStateRequest.packJobState(w, state);
        }
    }

    private static /* synthetic */ CompletionStage lambda$process$3(CompletableFuture idsAsync, UUID id) {
        return idsAsync.thenApply(ids -> out -> {
            out.packUuid(id);
            ClientComputeExecuteMapReduceRequest.packJobIds(out, ids);
        });
    }
}

