/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.authentication.UsernamePasswordCredentials;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BasicAuthUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthUtils.class);
    private static final String PREFIX = "Basic ";
    private static final String DELIMITER = ":";

    private BasicAuthUtils() {
    }

    @NonNull
    public static Optional<UsernamePasswordCredentials> parseCredentials(@NonNull String authorization) {
        return Optional.of(authorization).filter(s -> s.startsWith(PREFIX)).map(s -> s.substring(PREFIX.length())).flatMap(BasicAuthUtils::decode);
    }

    private static Optional<UsernamePasswordCredentials> decode(String credentials) {
        byte[] decoded;
        try {
            decoded = Base64.getDecoder().decode(credentials);
        }
        catch (IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error while trying to Base 64 decode: {}", (Object)credentials);
            }
            return Optional.empty();
        }
        String token = new String(decoded, StandardCharsets.UTF_8);
        int index = token.indexOf(DELIMITER);
        if (index == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bad format of the basic auth header - Delimiter : not found");
            }
            return Optional.empty();
        }
        return Optional.of(new UsernamePasswordCredentials(token.substring(0, index), token.substring(index + DELIMITER.length())));
    }
}

