/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.call.sql;

import jakarta.inject.Singleton;
import org.apache.ignite3.internal.cli.call.sql.InvalidateCacheCallInput;
import org.apache.ignite3.internal.cli.core.call.Call;
import org.apache.ignite3.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite3.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.rest.client.api.SqlApi;
import org.apache.ignite3.rest.client.invoker.ApiException;

@Singleton
public class InvalidatePlannerCacheCall
implements Call<InvalidateCacheCallInput, String> {
    private final ApiClientFactory clientFactory;

    public InvalidatePlannerCacheCall(ApiClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public DefaultCallOutput<String> execute(InvalidateCacheCallInput input) {
        SqlApi client = this.createApiClient(input);
        try {
            client.clearCache(input.getTables());
            return DefaultCallOutput.success("Successfully cleared SQL query plan cache.");
        }
        catch (ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.clusterUrl()));
        }
    }

    private SqlApi createApiClient(InvalidateCacheCallInput input) {
        return new SqlApi(this.clientFactory.getClient(input.clusterUrl()));
    }
}

