/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.commands.node.metric;

import jakarta.inject.Inject;
import org.apache.ignite3.internal.cli.call.node.metric.NodeMetricSetListCall;
import org.apache.ignite3.internal.cli.commands.BaseCommand;
import org.apache.ignite3.internal.cli.commands.node.NodeUrlMixin;
import org.apache.ignite3.internal.cli.commands.questions.ConnectToClusterQuestion;
import org.apache.ignite3.internal.cli.core.call.UrlCallInput;
import org.apache.ignite3.internal.cli.core.exception.handler.ClusterNotInitializedExceptionHandler;
import org.apache.ignite3.internal.cli.core.flow.builder.Flows;
import org.apache.ignite3.internal.cli.decorators.MetricSetListDecorator;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"Lists node metrics"})
public class NodeMetricSetListReplCommand
extends BaseCommand
implements Runnable {
    @CommandLine.Mixin
    private NodeUrlMixin nodeUrl;
    @CommandLine.Option(names={"--plain"}, description={"Display output with plain formatting. Might be useful if you want to pipe the output to another command"})
    private boolean plain;
    @Inject
    private NodeMetricSetListCall call;
    @Inject
    private ConnectToClusterQuestion question;

    @Override
    public void run() {
        this.runFlow(this.question.askQuestionIfNotConnected(this.nodeUrl.getNodeUrl()).map(UrlCallInput::new).then(Flows.fromCall(this.call)).exceptionHandler(ClusterNotInitializedExceptionHandler.createReplHandler("Cannot list metrics")).print(new MetricSetListDecorator(this.plain)));
    }
}

