/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.events;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.ignite3.internal.compute.events.ComputeEventMetadata;
import org.apache.ignite3.internal.eventlog.api.EventLog;
import org.apache.ignite3.internal.eventlog.api.IgniteEventType;
import org.apache.ignite3.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class ComputeEventsFactory {
    public static void logJobQueuedEvent(EventLog eventLog, @Nullable ComputeEventMetadata eventMetadata) {
        ComputeEventsFactory.logEvent(eventLog, IgniteEventType.COMPUTE_JOB_QUEUED, eventMetadata);
    }

    public static void logJobExecutingEvent(EventLog eventLog, @Nullable ComputeEventMetadata eventMetadata) {
        ComputeEventsFactory.logEvent(eventLog, IgniteEventType.COMPUTE_JOB_EXECUTING, eventMetadata);
    }

    public static void logJobFailedEvent(EventLog eventLog, @Nullable ComputeEventMetadata eventMetadata) {
        ComputeEventsFactory.logEvent(eventLog, IgniteEventType.COMPUTE_JOB_FAILED, eventMetadata);
    }

    public static void logJobCompletedEvent(EventLog eventLog, @Nullable ComputeEventMetadata eventMetadata) {
        ComputeEventsFactory.logEvent(eventLog, IgniteEventType.COMPUTE_JOB_COMPLETED, eventMetadata);
    }

    public static void logJobCancelingEvent(EventLog eventLog, @Nullable ComputeEventMetadata eventMetadata) {
        ComputeEventsFactory.logEvent(eventLog, IgniteEventType.COMPUTE_JOB_CANCELING, eventMetadata);
    }

    public static void logJobCanceledEvent(EventLog eventLog, @Nullable ComputeEventMetadata eventMetadata) {
        ComputeEventsFactory.logEvent(eventLog, IgniteEventType.COMPUTE_JOB_CANCELED, eventMetadata);
    }

    public static void logEvent(EventLog eventLog, IgniteEventType eventType, @Nullable ComputeEventMetadata eventMetadata) {
        if (eventMetadata == null) {
            return;
        }
        eventLog.log(eventType.name(), () -> {
            LinkedHashMap<String, Object> fields = IgniteUtils.newLinkedHashMap(8);
            fields.put("type", (Object)eventMetadata.type());
            fields.put("className", eventMetadata.jobClassName());
            fields.put("targetNode", eventMetadata.targetNode());
            fields.put("initiatorNode", eventMetadata.initiatorNode());
            ComputeEventsFactory.putIfNotNull(fields, "jobId", eventMetadata.jobId());
            ComputeEventsFactory.putIfNotNull(fields, "taskId", eventMetadata.taskId());
            ComputeEventsFactory.putIfNotNull(fields, "tableName", eventMetadata.tableName());
            ComputeEventsFactory.putIfNotNull(fields, "clientAddress", eventMetadata.clientAddress());
            return eventType.builder().user(eventMetadata.eventUser()).timestamp(System.currentTimeMillis()).fields(fields).build();
        });
    }

    private static void putIfNotNull(Map<String, Object> map, String key, @Nullable Object value) {
        if (value != null) {
            map.put(key, value);
        }
    }

    static class FieldNames {
        static final String TYPE = "type";
        static final String CLASS_NAME = "className";
        static final String JOB_ID = "jobId";
        static final String TARGET_NODE = "targetNode";
        static final String INITIATOR_NODE = "initiatorNode";
        static final String TASK_ID = "taskId";
        static final String TABLE_NAME = "tableName";
        static final String CLIENT_ADDRESS = "clientAddress";

        FieldNames() {
        }
    }
}

