/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metastorage.command;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.metastorage.CommandId;
import org.apache.ignite3.internal.metastorage.command.MultiInvokeCommand;
import org.apache.ignite3.internal.metastorage.command.MultiInvokeCommandBuilder;
import org.apache.ignite3.internal.metastorage.command.MultiInvokeCommandSerializer;
import org.apache.ignite3.internal.metastorage.dsl.Iif;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class MultiInvokeCommandImpl
implements MultiInvokeCommand,
Cloneable {
    public static final short GROUP_TYPE = 111;
    public static final short TYPE = 11;
    @IgniteToStringInclude
    private final CommandId id;
    @IgniteToStringInclude
    private final Iif iif;
    @IgniteToStringInclude
    private final HybridTimestamp initiatorTime;
    @IgniteToStringInclude
    private HybridTimestamp safeTime;

    private MultiInvokeCommandImpl(CommandId id, Iif iif, HybridTimestamp initiatorTime, HybridTimestamp safeTime) {
        this.id = id;
        this.iif = iif;
        this.initiatorTime = initiatorTime;
        this.safeTime = safeTime;
    }

    @Override
    public CommandId id() {
        return this.id;
    }

    @Override
    public Iif iif() {
        return this.iif;
    }

    @Override
    public HybridTimestamp initiatorTime() {
        return this.initiatorTime;
    }

    @Override
    public void safeTime(HybridTimestamp safeTime) {
        this.safeTime = safeTime;
    }

    @Override
    public HybridTimestamp safeTime() {
        return this.safeTime;
    }

    public MessageSerializer serializer() {
        return MultiInvokeCommandSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 111;
    }

    public String toString() {
        return S.toString(MultiInvokeCommandImpl.class, this);
    }

    @Override
    public short messageType() {
        return 11;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MultiInvokeCommandImpl otherMessage = (MultiInvokeCommandImpl)other;
        return Objects.equals(this.id, otherMessage.id) && Objects.equals(this.iif, otherMessage.iif) && Objects.equals(this.initiatorTime, otherMessage.initiatorTime) && Objects.equals(this.safeTime, otherMessage.safeTime);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.id, this.iif, this.initiatorTime, this.safeTime);
        return result;
    }

    @Override
    public MultiInvokeCommandImpl clone() {
        try {
            return (MultiInvokeCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static MultiInvokeCommandBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.id != null) {
            this.id.prepareMarshal(usedDescriptors, marshaller);
        }
        if (this.iif != null) {
            this.iif.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.id != null) {
            this.id.unmarshal(marshaller, descriptorsObj);
        }
        if (this.iif != null) {
            this.iif.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements MultiInvokeCommandBuilder {
        private CommandId id;
        private Iif iif;
        private HybridTimestamp initiatorTime;
        private HybridTimestamp safeTime;

        private Builder() {
        }

        @Override
        public MultiInvokeCommandBuilder id(CommandId id) {
            Objects.requireNonNull(id, "id is not marked @Nullable");
            this.id = id;
            return this;
        }

        @Override
        public MultiInvokeCommandBuilder iif(Iif iif) {
            Objects.requireNonNull(iif, "iif is not marked @Nullable");
            this.iif = iif;
            return this;
        }

        @Override
        public MultiInvokeCommandBuilder initiatorTime(HybridTimestamp initiatorTime) {
            Objects.requireNonNull(initiatorTime, "initiatorTime is not marked @Nullable");
            this.initiatorTime = initiatorTime;
            return this;
        }

        @Override
        public MultiInvokeCommandBuilder safeTime(HybridTimestamp safeTime) {
            this.safeTime = safeTime;
            return this;
        }

        @Override
        public CommandId id() {
            return this.id;
        }

        @Override
        public Iif iif() {
            return this.iif;
        }

        @Override
        public HybridTimestamp initiatorTime() {
            return this.initiatorTime;
        }

        @Override
        public HybridTimestamp safeTime() {
            return this.safeTime;
        }

        @Override
        public MultiInvokeCommand build() {
            return new MultiInvokeCommandImpl(Objects.requireNonNull(this.id, "id is not marked @Nullable"), Objects.requireNonNull(this.iif, "iif is not marked @Nullable"), Objects.requireNonNull(this.initiatorTime, "initiatorTime is not marked @Nullable"), this.safeTime);
        }
    }
}

