/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization;

import java.io.IOException;
import org.apache.ignite3.internal.util.io.IgniteDataInput;
import org.apache.ignite3.internal.util.io.IgniteDataOutput;
import org.apache.ignite3.internal.versioned.VersionedSerialization;
import org.apache.ignite3.internal.versioned.VersionedSerializer;
import org.apache.ignite3.network.NetworkAddress;

public class NetworkAddressSerializer
extends VersionedSerializer<NetworkAddress> {
    public static final NetworkAddressSerializer INSTANCE = new NetworkAddressSerializer();

    @Override
    protected void writeExternalData(NetworkAddress address, IgniteDataOutput out) throws IOException {
        out.writeUTF(address.host());
        out.writeInt(address.port());
    }

    @Override
    protected NetworkAddress readExternalData(byte protoVer, IgniteDataInput in) throws IOException {
        String host = in.readUTF();
        int port = in.readInt();
        return new NetworkAddress(host, port);
    }

    public static byte[] serialize(NetworkAddress address) {
        return VersionedSerialization.toBytes(address, INSTANCE);
    }

    public static NetworkAddress deserialize(byte[] bytes) {
        return VersionedSerialization.fromBytes(bytes, INSTANCE);
    }
}

