/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.network.serialization;

import org.apache.ignite3.internal.network.NetworkMessage;
import org.apache.ignite3.internal.network.serialization.ClassDescriptor;
import org.apache.ignite3.internal.network.serialization.ClassDescriptorFactory;
import org.apache.ignite3.internal.network.serialization.ClassDescriptorRegistry;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializationRegistry;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.UserObjectSerializationContext;

public class SerializationService {
    private final MessageSerializationRegistry messageRegistry;
    private final ClassDescriptorRegistry localDescriptorRegistry;
    private final ClassDescriptorFactory descriptorFactory;

    public SerializationService(MessageSerializationRegistry messageRegistry, UserObjectSerializationContext userObjectSerializationContext) {
        this.messageRegistry = messageRegistry;
        this.localDescriptorRegistry = userObjectSerializationContext.descriptorRegistry();
        this.descriptorFactory = userObjectSerializationContext.descriptorFactory();
    }

    public MessageSerializationRegistry serializationRegistry() {
        return this.messageRegistry;
    }

    public <T extends NetworkMessage> MessageSerializer<T> createSerializer(short groupType, short messageType) {
        return this.messageRegistry.createSerializer(groupType, messageType);
    }

    public <T extends NetworkMessage> MessageDeserializer<T> createDeserializer(short groupType, short messageType) {
        return this.messageRegistry.createDeserializer(groupType, messageType);
    }

    public ClassDescriptor getOrCreateLocalDescriptor(Class<?> clazz) {
        ClassDescriptor descriptor = this.localDescriptorRegistry.getDescriptor(clazz);
        if (descriptor != null) {
            return descriptor;
        }
        return this.descriptorFactory.create(clazz);
    }

    public ClassDescriptor getLocalDescriptor(int descriptorId) {
        return this.localDescriptorRegistry.getDescriptor(descriptorId);
    }

    public ClassDescriptorRegistry getLocalDescriptorRegistry() {
        return this.localDescriptorRegistry;
    }
}

