/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.command;

import java.util.List;
import java.util.UUID;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommandV2;
import org.apache.ignite3.internal.partition.replicator.network.command.FinishTxCommandV2Builder;
import org.apache.ignite3.internal.tx.message.EnlistedPartitionGroupMessage;

class FinishTxCommandV2Deserializer
implements MessageDeserializer<FinishTxCommandV2> {
    private final FinishTxCommandV2Builder msg;

    FinishTxCommandV2Deserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.finishTxCommandV2();
    }

    @Override
    public Class<FinishTxCommandV2> klass() {
        return FinishTxCommandV2.class;
    }

    @Override
    public FinishTxCommandV2 getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("commit");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commit(tmp);
                reader.incrementState();
            }
            case 1: {
                HybridTimestamp tmp = reader.readHybridTimestamp("commitTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitTimestamp(tmp);
                reader.incrementState();
            }
            case 2: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 3: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 4: {
                Comparable<HybridTimestamp> tmp = reader.readList("partitions", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.partitions((List<EnlistedPartitionGroupMessage>)((Object)tmp));
                reader.incrementState();
            }
            case 5: {
                Comparable<HybridTimestamp> tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 6: {
                Comparable<HybridTimestamp> tmp = reader.readUuid("txId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.txId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(FinishTxCommandV2.class);
    }
}

