/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import org.apache.ignite3.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageWriter;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyDirectMultiRowReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyDirectMultiRowReplicaRequestImpl;

class ReadOnlyDirectMultiRowReplicaRequestSerializer
implements MessageSerializer<ReadOnlyDirectMultiRowReplicaRequest> {
    public static final ReadOnlyDirectMultiRowReplicaRequestSerializer INSTANCE = new ReadOnlyDirectMultiRowReplicaRequestSerializer();

    private ReadOnlyDirectMultiRowReplicaRequestSerializer() {
    }

    @Override
    public boolean writeMessage(ReadOnlyDirectMultiRowReplicaRequest msg, MessageWriter writer) throws MessageMappingException {
        ReadOnlyDirectMultiRowReplicaRequestImpl message = (ReadOnlyDirectMultiRowReplicaRequestImpl)msg;
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)7)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeBoxedLong("enlistmentConsistencyToken", message.enlistmentConsistencyToken());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeMessage("groupId", message.groupId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeList("primaryKeys", message.primaryKeys(), MessageCollectionItemType.BYTE_BUFFER);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                int idShifted = message.requestType() == null ? 0 : message.requestType().id() + 1;
                boolean written = writer.writeInt("requestType", idShifted);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeInt("schemaVersion", message.schemaVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeInt("tableId", message.tableId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeHybridTimestamp("timestamp", message.timestamp());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

