/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rest.api.node;

import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Produces;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.ignite3.internal.rest.api.Problem;
import org.apache.ignite3.internal.rest.api.node.NodeInfo;
import org.apache.ignite3.internal.rest.api.node.NodeState;
import org.apache.ignite3.internal.rest.api.node.NodeVersion;

@Controller(value="/management/v1/node")
@Tag(name="nodeManagement")
public interface NodeManagementApi {
    @Get(value="state")
    @Operation(operationId="nodeState", summary="Get node state", description="Gets node state.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Node state.", content={@Content(mediaType="application/json", schema=@Schema(implementation=NodeState.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public NodeState state();

    @Get(value="info")
    @Operation(operationId="nodeInfo", summary="Get node information", description="Gets information about the node.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Node info.", content={@Content(mediaType="application/json", schema=@Schema(implementation=NodeInfo.class))}), @ApiResponse(responseCode="500", description="Internal error.", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    public NodeInfo info();

    @Get(value="version")
    @Operation(operationId="nodeVersion", summary="Get application version on node", description="Gets the version of Apache Ignite the node uses.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Node version.", content={@Content(mediaType="application/json", schema=@Schema(implementation=NodeVersion.class))}), @ApiResponse(responseCode="500", description="Internal error", content={@Content(mediaType="application/problem+json", schema=@Schema(implementation=Problem.class))})})
    @Produces(value={"application/problem+json"})
    public NodeVersion version();
}

