/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.restart;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite3.Ignite;
import org.apache.ignite3.internal.restart.IgniteAttachmentLock;
import org.apache.ignite3.internal.restart.RefCache;

abstract class RestartProofApiObject<T> {
    private final IgniteAttachmentLock attachmentLock;
    private final RefCache<T> delegateCache;

    RestartProofApiObject(IgniteAttachmentLock attachmentLock, Ignite initialIgnite, Function<Ignite, T> delegateFactory) {
        this.attachmentLock = attachmentLock;
        this.delegateCache = new RefCache<T>(initialIgnite, delegateFactory);
    }

    final <U> U attached(Function<T, U> action) {
        return (U)this.attachmentLock.attached((? super Ignite ignite) -> action.apply(this.actualInstanceFor((Ignite)ignite)));
    }

    final void consumeAttached(Consumer<T> action) {
        this.attachmentLock.consumeAttached((? super Ignite ignite) -> action.accept(this.actualInstanceFor((Ignite)ignite)));
    }

    final <U> CompletableFuture<U> attachedAsync(Function<T, CompletableFuture<U>> action) {
        return this.attachmentLock.attachedAsync((? super Ignite ignite) -> (CompletableFuture)action.apply(this.actualInstanceFor((Ignite)ignite)));
    }

    private T actualInstanceFor(Ignite ignite) {
        return this.delegateCache.actualFor(ignite);
    }
}

