/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec.rel;

import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.sql.engine.exec.ExecutionContext;
import org.apache.ignite3.internal.sql.engine.exec.PartitionProvider;
import org.apache.ignite3.internal.sql.engine.exec.PartitionWithConsistencyToken;
import org.apache.ignite3.internal.sql.engine.exec.RowHandler;
import org.apache.ignite3.internal.sql.engine.exec.ScannableTable;
import org.apache.ignite3.internal.sql.engine.exec.rel.StorageScanNode;
import org.apache.ignite3.internal.util.SubscriptionUtils;
import org.apache.ignite3.internal.util.TransformingIterator;
import org.jetbrains.annotations.Nullable;

public class TableScanNode<RowT>
extends StorageScanNode<RowT> {
    private final ScannableTable table;
    private final PartitionProvider<RowT> partitionProvider;
    private final RowHandler.RowFactory<RowT> rowFactory;
    private final int @Nullable [] requiredColumns;

    public TableScanNode(ExecutionContext<RowT> ctx, RowHandler.RowFactory<RowT> rowFactory, ScannableTable table, PartitionProvider<RowT> partitionProvider, @Nullable Predicate<RowT> filters, @Nullable Function<RowT, RowT> rowTransformer, @Nullable ImmutableIntList requiredColumns) {
        super(ctx, filters, rowTransformer);
        this.table = table;
        this.partitionProvider = partitionProvider;
        this.rowFactory = rowFactory;
        this.requiredColumns = requiredColumns == null ? null : requiredColumns.toIntArray();
    }

    @Override
    protected Flow.Publisher<RowT> scan() {
        List<PartitionWithConsistencyToken> partitions = this.partitionProvider.getPartitions(this.context());
        TransformingIterator<PartitionWithConsistencyToken, Flow.Publisher> it = new TransformingIterator<PartitionWithConsistencyToken, Flow.Publisher>(partitions.iterator(), p -> this.table.scan(this.context(), (PartitionWithConsistencyToken)p, this.rowFactory, this.requiredColumns));
        return SubscriptionUtils.concat(it);
    }
}

