/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel;

import java.util.List;
import java.util.stream.Stream;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.ignite3.internal.sql.engine.externalize.RelInputEx;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.MultiBounds;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.sql.engine.rel.ProjectableFilterableTableScan;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.internal.sql.engine.util.RexUtils;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIndexScan
extends ProjectableFilterableTableScan {
    protected final String idxName;
    @Nullable
    protected final List<SearchBounds> searchBounds;
    protected final IgniteIndex.Type type;

    AbstractIndexScan(RelInput input) {
        super(input);
        this.idxName = input.getString("index");
        this.type = (IgniteIndex.Type)input.getEnum("type", IgniteIndex.Type.class);
        this.searchBounds = ((RelInputEx)input).getSearchBounds("searchBounds");
    }

    protected AbstractIndexScan(RelOptCluster cluster, RelTraitSet traitSet, List<RelHint> hints, RelOptTable table, String idxName, IgniteIndex.Type type, @Nullable List<String> names, @Nullable List<RexNode> proj, @Nullable RexNode cond, @Nullable List<SearchBounds> searchBounds, @Nullable ImmutableIntList reqColumns) {
        super(cluster, traitSet, hints, table, names, proj, cond, reqColumns);
        this.idxName = idxName;
        this.type = type;
        this.searchBounds = searchBounds;
    }

    @Override
    protected RelWriter explainTerms0(RelWriter pw) {
        pw = pw.item("index", (Object)this.idxName).item("type", (Object)this.type.name()).itemIf("searchBounds", this.searchBounds, this.searchBounds != null);
        return super.explainTerms0(pw);
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode condition0 = shuttle.apply(this.condition);
        List projects0 = shuttle.apply(this.projects);
        List<SearchBounds> searchBounds0 = RexUtils.processSearchBounds(shuttle, this.searchBounds);
        if (condition0 == this.condition && projects0 == this.projects && this.searchBounds == searchBounds0) {
            return this;
        }
        return this.copy(projects0, condition0, searchBounds0);
    }

    @Override
    protected final ProjectableFilterableTableScan copy(@Nullable List<RexNode> newProjects, @Nullable RexNode newCondition) {
        throw new IllegalStateException("Should never be called.");
    }

    protected abstract AbstractIndexScan copy(@Nullable List<RexNode> var1, @Nullable RexNode var2, @Nullable List<SearchBounds> var3);

    public String indexName() {
        return this.idxName;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        double rows = this.table.getRowCount();
        double cost = 0.0;
        if (this.type == IgniteIndex.Type.HASH) {
            boolean notExact;
            boolean bl = notExact = this.searchBounds() == null || this.searchBounds().stream().anyMatch(bound -> bound.type() == SearchBounds.Type.RANGE);
            if (!notExact) {
                notExact = this.searchBounds().stream().flatMap(bound -> bound instanceof MultiBounds ? ((MultiBounds)bound).bounds().stream() : Stream.of(bound)).anyMatch(bound -> bound.type() != SearchBounds.Type.EXACT);
            }
            if (notExact) {
                return planner.getCostFactory().makeInfiniteCost();
            }
        }
        double indexRowPassThroughCost = 4.0;
        if (this.condition == null) {
            cost = rows * indexRowPassThroughCost;
        } else {
            double selectivity = 1.0;
            RexBuilder builder = this.getCluster().getRexBuilder();
            if (this.searchBounds() != null) {
                selectivity = mq.getSelectivity((RelNode)this, RexUtil.composeConjunction((RexBuilder)builder, Commons.transform(this.searchBounds(), b -> b == null ? null : b.condition())));
                cost = Math.max(Math.log(rows), 1.0) * 3.0;
            }
            cost += Math.max(rows *= selectivity, 1.0) * (3.0 + indexRowPassThroughCost);
        }
        return planner.getCostFactory().makeCost(rows, cost, 0.0);
    }

    public List<SearchBounds> searchBounds() {
        return this.searchBounds;
    }

    @Override
    public IgniteRelWriter explainAttributes(IgniteRelWriter writer) {
        super.explainAttributes(writer).addIndex(this.idxName, this.type);
        if (this.searchBounds != null) {
            writer.addSearchBounds(this.searchBounds);
        }
        return writer;
    }
}

